/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import org.refcodes.data.Delimiters;
import org.refcodes.mixin.ArrayIndexAccessor;
import org.refcodes.mixin.DelimitersAccessor;
import org.refcodes.mixin.EnvelopeAccessor;
import org.refcodes.properties.DocumentMetrics;

public class DocumentMetricsImpl
implements DocumentMetrics {
    private static final char[] DEFAULT_DELIMITERS = Delimiters.PROPERTIES.getChars();
    private static final boolean DEFAULT_ENVELOPE = false;
    private static final boolean DEFAULT_ARRAY_INDEX = false;
    private final boolean _isArrayIndex;
    private final boolean _isEnvelope;
    private final char[] _delimiters;

    private DocumentMetricsImpl(Builder builder) {
        this._isArrayIndex = builder.isArrayIndex;
        this._isEnvelope = builder.isEnvelope;
        this._delimiters = builder.delimiters;
    }

    public DocumentMetricsImpl() {
        this(false, false, DEFAULT_DELIMITERS);
    }

    public DocumentMetricsImpl(boolean aEnvelope, boolean aArrayIndex) {
        this(aEnvelope, aArrayIndex, DEFAULT_DELIMITERS);
    }

    public DocumentMetricsImpl(char ... aDelimiters) {
        this(false, false, aDelimiters);
    }

    public DocumentMetricsImpl(boolean aEnvelope, boolean aArrayIndex, char ... aDelimiters) {
        this._isEnvelope = aEnvelope;
        this._isArrayIndex = aArrayIndex;
        this._delimiters = aDelimiters;
    }

    public boolean isArrayIndex() {
        return this._isArrayIndex;
    }

    public boolean isEnvelope() {
        return this._isEnvelope;
    }

    public char[] getDelimiters() {
        return this._delimiters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements ArrayIndexAccessor.ArrayIndexBuilder<Builder>,
    EnvelopeAccessor.EnvelopeBuilder<Builder>,
    DelimitersAccessor.DelimitersBuilder<Builder> {
        private boolean isArrayIndex = false;
        private boolean isEnvelope = false;
        private char[] delimiters = DEFAULT_DELIMITERS;

        private Builder() {
        }

        public Builder withArrayIndex(boolean isArrayIndex) {
            this.isArrayIndex = isArrayIndex;
            return this;
        }

        public Builder withEnvelope(boolean isEnvelope) {
            this.isEnvelope = isEnvelope;
            return this;
        }

        public Builder withDelimiters(char ... delimiters) {
            this.delimiters = delimiters;
            return this;
        }

        public DocumentMetrics build() {
            return new DocumentMetricsImpl(this);
        }
    }
}

