/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.refcodes.data.Delimiters;
import org.refcodes.mixin.ArrayIndexAccessor;
import org.refcodes.mixin.DelimitersAccessor;
import org.refcodes.mixin.EnvelopeAccessor;
import org.refcodes.struct.ext.factory.DocumentProperty;

public interface DocumentMetrics
extends DelimitersAccessor,
EnvelopeAccessor,
ArrayIndexAccessor {
    default public Map<String, String> toProperties(char aDelimiter) {
        HashMap<String, String> theProperties = new HashMap<String, String>();
        theProperties.put(DocumentProperty.DELIMITER.getKey(), "" + aDelimiter);
        theProperties.put(DocumentProperty.DELIMITERS.getKey(), new String(DocumentMetrics.toDelimiters(aDelimiter, this.getDelimiters(), Delimiters.PROPERTIES.getChars())));
        theProperties.put(DocumentProperty.ENVELOPE.getKey(), Boolean.toString(this.isEnvelope()));
        return theProperties;
    }

    default public Map<String, String> toProperties(String aComment, char aDelimiter) {
        HashMap<String, String> theProperties = new HashMap<String, String>();
        theProperties.put(DocumentProperty.COMMENT.getKey(), aComment);
        theProperties.put(DocumentProperty.DELIMITER.getKey(), "" + aDelimiter);
        theProperties.put(DocumentProperty.ARRAY_INDEX.getKey(), Boolean.toString(this.isArrayIndex()));
        theProperties.put(DocumentProperty.ENVELOPE.getKey(), Boolean.toString(this.isEnvelope()));
        return theProperties;
    }

    public static char[] toDelimiters(char aDelimiter, char[] aDelimiters, char[] aDefaultDelimiters) {
        if (aDelimiters != null && aDelimiters.length != 0) {
            return aDelimiters;
        }
        LinkedList<Character> theChars = new LinkedList<Character>();
        theChars.add(Character.valueOf(aDelimiter));
        for (char aDefaultDelimiter : aDefaultDelimiters) {
            if (theChars.contains(Character.valueOf(aDefaultDelimiter))) continue;
            theChars.add(Character.valueOf(aDefaultDelimiter));
        }
        char[] theDelimiters = new char[theChars.size()];
        for (int i = 0; i < theDelimiters.length; ++i) {
            theDelimiters[i] = ((Character)theChars.get(i)).charValue();
        }
        return theDelimiters;
    }
}

