/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.IOException;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.controlflow.ThreadMode;
import org.refcodes.data.IoPollLoopTime;
import org.refcodes.properties.AbstractResourcePropertiesDecorator;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ScheduledResourceProperties;

public class ScheduledResourcePropertiesDecorator
extends AbstractResourcePropertiesDecorator<ResourceProperties>
implements ScheduledResourceProperties {
    private PropertiesScheduler _scheduler;

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, IoPollLoopTime.NORM.getTimeInMs(), ReloadMode.ORPHAN_REMOVAL);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, int n) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, n, ReloadMode.ORPHAN_REMOVAL);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, ReloadMode reloadMode) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, IoPollLoopTime.NORM.getTimeInMs(), reloadMode);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, int n, ReloadMode reloadMode) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, n, reloadMode, ThreadMode.DAEMON);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, ThreadMode threadMode) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, IoPollLoopTime.NORM.getTimeInMs(), ReloadMode.ORPHAN_REMOVAL, threadMode);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, int n, ThreadMode threadMode) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, n, ReloadMode.ORPHAN_REMOVAL, threadMode);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, ReloadMode reloadMode, ThreadMode threadMode) throws IOException, ParseException, IllegalStateException {
        this(resourceProperties, IoPollLoopTime.NORM.getTimeInMs(), reloadMode, threadMode);
    }

    public ScheduledResourcePropertiesDecorator(ResourceProperties resourceProperties, int n, ReloadMode reloadMode, ThreadMode threadMode) throws IOException, ParseException, IllegalStateException {
        super(resourceProperties);
        this.reload(reloadMode);
        this._scheduler = new PropertiesScheduler(resourceProperties, n, reloadMode, threadMode);
        this.startUnchecked();
    }

    public synchronized void start() throws StartException {
        this._scheduler.start();
    }

    public synchronized void stop() throws StopException {
        this._scheduler.stop();
    }

    public synchronized void dispose() {
        if (this._scheduler != null) {
            this._scheduler.dispose();
            this._scheduler = null;
        }
    }

    static class PropertiesScheduler {
        private Timer _timer = null;
        private ReloadMode _reloadMode;
        private int _scheduleTimeInMillis;
        private ResourceProperties _properties;
        private ThreadMode _threadMode;

        PropertiesScheduler(ResourceProperties resourceProperties, int n, ReloadMode reloadMode, ThreadMode threadMode) {
            this._reloadMode = reloadMode;
            this._scheduleTimeInMillis = n;
            this._properties = resourceProperties;
            this._threadMode = threadMode;
        }

        public synchronized void start() throws StartException {
            if (this._timer != null) {
                throw new StartException("Unable to start the scheduler which has not been stopped before!");
            }
            this._timer = new Timer(this._threadMode == ThreadMode.DAEMON);
            this._timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        _properties.reload(_reloadMode);
                    }
                    catch (IOException | IllegalStateException | ParseException exception) {
                        // empty catch block
                    }
                }
            }, this._scheduleTimeInMillis, (long)this._scheduleTimeInMillis);
        }

        public synchronized void stop() throws StopException {
            if (this._timer == null) {
                throw new StopException("Unable to stop the scheduler which has not been started again!");
            }
            this._timer.cancel();
            this._timer = null;
        }

        public synchronized void dispose() {
            Timer timer = this._timer;
            if (timer != null) {
                timer.cancel();
            }
            this._timer = null;
            this._properties = null;
        }
    }
}

