/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcSize;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;

public class CrcAlgorithmImpl
implements CrcAlgorithm {
    final int _crcBitWidth;
    private final long _initCrc;
    private final String _name;
    private final long _polynomial;
    private final boolean _refIn;
    private final boolean _refOut;
    private final long _xorOut;
    private final long[] _table = new long[256];
    private long _mask = -1L;
    private CrcSize _crcWidth = null;

    public CrcAlgorithmImpl(String string, int n, long l, long l2, boolean bl, boolean bl2, long l3) {
        this._name = string;
        this._initCrc = l2;
        this._polynomial = l;
        this._refIn = bl;
        this._refOut = bl2;
        this._xorOut = l3;
        this._crcBitWidth = n;
        if (this._crcBitWidth < 64) {
            this._mask = (1L << this._crcBitWidth) - 1L;
        }
        for (int i = 0; i < this._table.length; ++i) {
            long l4 = i;
            if (this._refIn) {
                l4 = NumericalUtility.toReversedLong(l4, this._crcBitWidth);
            } else if (this._crcBitWidth > 8) {
                l4 <<= this._crcBitWidth - 8;
            }
            long l5 = 1L << this._crcBitWidth - 1;
            for (int j = 0; j < 8; ++j) {
                if ((l4 & l5) != 0L) {
                    l4 = l4 << 1 ^ this._polynomial;
                    continue;
                }
                l4 <<= 1;
            }
            if (this._refOut) {
                l4 = NumericalUtility.toReversedLong(l4, this._crcBitWidth);
            }
            this._table[i] = l4 & this._mask;
        }
    }

    @Override
    public long toCrcChecksum(byte by) {
        return this.toCrcChecksum(new byte[]{by}, 0, 1);
    }

    @Override
    public long toCrcChecksum(long l, byte by) {
        return this.toCrcChecksum(l, new byte[]{by}, 0, 1);
    }

    @Override
    public long toCrcChecksum(byte[] byArray) {
        return this.toCrcChecksum(byArray, 0, byArray.length);
    }

    @Override
    public long toCrcChecksum(long l, byte[] byArray) {
        return this.toCrcChecksum(l, byArray, 0, byArray.length);
    }

    @Override
    public long toCrcChecksum(byte[] byArray, int n, int n2) {
        long l = this._refOut ? NumericalUtility.toReversedLong(this._initCrc, this._crcBitWidth) : this._initCrc;
        long l2 = this.toCrcChecksum(l, byArray, n, n2);
        return (l2 ^ this._xorOut) & this._mask;
    }

    @Override
    public long toCrcChecksum(long l, byte[] byArray, int n, int n2) {
        long l2 = l;
        if (this._refOut) {
            for (int i = n; i < n + n2; ++i) {
                l2 = this._table[(int)((l2 ^ (long)byArray[i]) & 0xFFL)] ^ l2 >>> 8;
                l2 &= this._mask;
            }
        } else {
            int n3 = this._crcBitWidth - 8;
            n3 = n3 < 0 ? 0 : n3;
            for (int i = n; i < n + n2; ++i) {
                l2 = this._table[(int)((l2 >> n3 ^ (long)byArray[i]) & 0xFFL)] ^ l2 << 8;
                l2 &= this._mask;
            }
        }
        return l2;
    }

    @Override
    public byte[] toCrcBytes(byte by, Endianess endianess) {
        return this.toCrcBytes(new byte[]{by}, 0, 1, endianess);
    }

    @Override
    public byte[] toCrcBytes(long l, byte by, Endianess endianess) {
        return this.toCrcBytes(l, new byte[]{by}, 0, 1, endianess);
    }

    @Override
    public byte[] toCrcBytes(byte[] byArray, Endianess endianess) {
        return this.toCrcBytes(byArray, 0, byArray.length, endianess);
    }

    @Override
    public byte[] toCrcBytes(long l, byte[] byArray, Endianess endianess) {
        return this.toCrcBytes(l, byArray, 0, byArray.length, endianess);
    }

    @Override
    public byte[] toCrcBytes(byte[] byArray, int n, int n2, Endianess endianess) {
        long l = this.toCrcChecksum(byArray, n, n2);
        return endianess.toUnsignedBytes(l, this._crcBitWidth / 8);
    }

    @Override
    public byte[] toCrcBytes(long l, byte[] byArray, int n, int n2, Endianess endianess) {
        long l2 = this.toCrcChecksum(l, byArray, n, n2);
        return endianess.toUnsignedBytes(l2, this._crcBitWidth / 8);
    }

    @Override
    public int getCrcWidth() {
        return this._crcBitWidth / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrcSize getCrcSize() {
        if (this._crcWidth == null) {
            CrcAlgorithmImpl crcAlgorithmImpl = this;
            synchronized (crcAlgorithmImpl) {
                if (this._crcWidth == null) {
                    this._crcWidth = CrcSize.toCrcCategory(this._crcBitWidth / 8);
                }
            }
        }
        return this._crcWidth;
    }

    public String getName() {
        return this._name;
    }
}

