/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.mixin.ValueAccessor;

public class BitwiseOperationBuilder
implements ValueAccessor.ValueProperty<Integer>,
ValueAccessor.ValueBuilder<Integer, BitwiseOperationBuilder> {
    private Integer _value = 0;

    public Integer getValue() {
        return this._value;
    }

    public void setValue(Integer n) {
        this._value = n;
    }

    public BitwiseOperationBuilder withAnd(Integer n) {
        this._value = BitwiseOperationBuilder.toBitwiseAND(this._value, n);
        return this;
    }

    public BitwiseOperationBuilder withOr(Integer n) {
        this._value = BitwiseOperationBuilder.toBitwiseOR(this._value, n);
        return this;
    }

    public BitwiseOperationBuilder withXor(Integer n) {
        this._value = BitwiseOperationBuilder.toBitwiseXOR(this._value, n);
        return this;
    }

    public BitwiseOperationBuilder withNot() {
        this._value = BitwiseOperationBuilder.toBitwiseNOT(this._value);
        return this;
    }

    public boolean isMaskable(int n) {
        return BitwiseOperationBuilder.isMaskable(this._value, n);
    }

    public boolean isTrueAt(int n) {
        return BitwiseOperationBuilder.isTrueAt(this._value, n);
    }

    public BitwiseOperationBuilder withValue(Integer n) {
        this.setValue(n);
        return this;
    }

    public static boolean isTrueAt(int n, int n2) {
        String string = Integer.toBinaryString(n);
        int n3 = string.length();
        if (n2 < 0 || n2 > n3 - 1) {
            return false;
        }
        return string.charAt(n3 - 1 - n2) == '1';
    }

    public static boolean isMaskable(int n, int n2) {
        String[] stringArray = BitwiseOperationBuilder.toBitStrings(n, n2);
        for (int i = 0; i < stringArray[0].length(); ++i) {
            if (stringArray[1].charAt(i) != '1' || stringArray[0].charAt(i) != '0') continue;
            return false;
        }
        return true;
    }

    protected static int toBitwiseAND(int n, int n2) {
        Object object = "";
        String[] stringArray = BitwiseOperationBuilder.toBitStrings(n, n2);
        for (int i = 0; i < stringArray[0].length(); ++i) {
            object = stringArray[0].charAt(i) == '1' && stringArray[1].charAt(i) == '1' ? (String)object + "1" : (String)object + "0";
        }
        return Integer.parseInt((String)object, 2);
    }

    protected static int toBitwiseNOT(int n) {
        Object object = "";
        String string = Integer.toBinaryString(n);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            object = string.charAt(i) == '1' ? (String)object + "0" : (String)object + "1";
        }
        return Integer.parseInt((String)object, 2);
    }

    protected static int toBitwiseOR(int n, int n2) {
        Object object = "";
        String[] stringArray = BitwiseOperationBuilder.toBitStrings(n, n2);
        for (int i = 0; i < stringArray[0].length(); ++i) {
            object = stringArray[0].charAt(i) == '1' || stringArray[1].charAt(i) == '1' ? (String)object + "1" : (String)object + "0";
        }
        return Integer.parseInt((String)object, 2);
    }

    protected static int toBitwiseXOR(int n, int n2) {
        Object object = "";
        String[] stringArray = BitwiseOperationBuilder.toBitStrings(n, n2);
        for (int i = 0; i < stringArray[0].length(); ++i) {
            object = stringArray[0].charAt(i) == '1' ^ stringArray[1].charAt(i) == '1' ? (String)object + "1" : (String)object + "0";
        }
        return Integer.parseInt((String)object, 2);
    }

    protected static String[] toBitStrings(int n, int n2) {
        Object object;
        Object object2;
        block3: {
            block2: {
                object2 = Integer.toBinaryString(n);
                object = Integer.toBinaryString(n2);
                if (((String)object2).length() <= ((String)object).length()) break block2;
                while (((String)object).length() < ((String)object2).length()) {
                    object = "0" + (String)object;
                }
                break block3;
            }
            if (((String)object2).length() >= ((String)object).length()) break block3;
            while (((String)object2).length() < ((String)object).length()) {
                object2 = "0" + (String)object2;
            }
        }
        return new String[]{object2, object};
    }
}

