/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.refcodes.matcher.RegExpMatcher;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.matcher.WildcardSubstitutesImpl;

public class RegExpMatcherImpl
implements RegExpMatcher {
    private Pattern _pattern;
    private String[] _wildcardNames = null;

    public RegExpMatcherImpl(Pattern aRegExp) {
        this._pattern = aRegExp;
        ArrayList<String> theGroups = new ArrayList<String>();
        Matcher theMatcher = Pattern.compile("\\(\\?<.*?>.*?\\)").matcher(this._pattern.pattern());
        while (theMatcher.find()) {
            String eGroup = theMatcher.group();
            int begin = eGroup.indexOf(60) + 1;
            int end = eGroup.indexOf(62);
            eGroup = eGroup.substring(begin, end);
            theGroups.add(eGroup);
        }
        this._wildcardNames = theGroups.toArray(new String[theGroups.size()]);
    }

    public RegExpMatcherImpl(String aRegExp) throws PatternSyntaxException {
        this(Pattern.compile(aRegExp));
    }

    @Override
    public String[] getWildcardNames() {
        return this._wildcardNames;
    }

    @Override
    public Pattern getPattern() {
        return this._pattern;
    }

    @Override
    public boolean isMatching(String aText) {
        Matcher theMatcher = this._pattern.matcher(aText);
        return theMatcher.matches();
    }

    @Override
    public WildcardSubstitutes toWildcardSubstitutes(String aText) {
        Matcher theMatcher = this._pattern.matcher(aText);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        String[] theWildcardReplacements = theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
        HashMap<String, String> theNamedWildcardSubstitutes = null;
        if (this._wildcardNames != null) {
            theNamedWildcardSubstitutes = new HashMap<String, String>();
            for (String eName : this._wildcardNames) {
                theNamedWildcardSubstitutes.put(eName, theMatcher.group(eName));
            }
        }
        return new WildcardSubstitutesImpl(theWildcardReplacements, theNamedWildcardSubstitutes);
    }

    @Override
    public String[] toWildcardReplacements(String aText) {
        Matcher theMatcher = this._pattern.matcher(aText);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacementAt(String aText, int aIndex) {
        Matcher theMatcher = this._pattern.matcher(aText);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndex < theMatcher.groupCount()) {
            return theMatcher.group(aIndex + 1);
        }
        throw new IllegalArgumentException("Your provided index <" + aIndex + "> exceeds the number if wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPattern().pattern() + "\" for current path \"" + aText + "\".");
    }

    @Override
    public String[] toWildcardReplacementsAt(String aText, int ... aIndexes) {
        Matcher theMatcher = this._pattern.matcher(aText);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndexes == null || aIndexes.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i : aIndexes) {
            if (i >= theMatcher.groupCount()) {
                throw new IllegalArgumentException("Your provided index <" + i + "> exceeds the number of wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPattern().pattern() + "\" for current path \"" + aText + "\".");
            }
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacement(String aText, String aWildcardName) {
        Matcher theMatcher = this._pattern.matcher(aText);
        if (!theMatcher.matches()) {
            return null;
        }
        try {
            return theMatcher.group(aWildcardName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Your provided name <" + aWildcardName + "> is not defined in your pattern \"" + this.getPattern().pattern() + "\" for current path \"" + aText + "\".", e);
        }
    }

    @Override
    public String[] toWildcardReplacements(String aText, String ... aWildcardNames) {
        Matcher theMatcher = this._pattern.matcher(aText);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aWildcardNames == null || aWildcardNames.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (String eWildcardName : aWildcardNames) {
            try {
                theWildcardSubstitutes.add(theMatcher.group(eWildcardName));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Your provided name <" + eWildcardName + "> is not defined in your pattern \"" + this.getPattern().pattern() + "\" for current path \"" + aText + "\".", e);
            }
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    public String toPattern() {
        return this._pattern.pattern();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._pattern == null ? 0 : this._pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegExpMatcherImpl other = (RegExpMatcherImpl)obj;
        return !(this._pattern == null ? other._pattern != null : !this._pattern.equals(other._pattern));
    }
}

