/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.refcodes.mixin.Clonable;

public class ReplaceInputStream
extends InputStream {
    private InputStream _inputStream;
    private byte[] _findBytes;
    private byte[] _replaceBytes;
    private Status _status = new Status();
    private Status _mark = null;

    public ReplaceInputStream(InputStream aInputStream, byte[] aFindBytes, byte[] aReplaceBytes) {
        if (aFindBytes == null || aFindBytes.length == 0) {
            throw new IllegalArgumentException("You must provide at an array of bytes with a length of at least <1> for the bytes to be replaced!");
        }
        this._findBytes = aFindBytes;
        this._replaceBytes = aReplaceBytes != null ? aReplaceBytes : new byte[]{};
        this._status.readBytes = new int[this._findBytes.length];
        this._inputStream = aInputStream;
    }

    public ReplaceInputStream(InputStream aInputStream, String aFindBytes, String aReplaceBytes) {
        this(aInputStream, aFindBytes.getBytes(), aReplaceBytes.getBytes());
    }

    public ReplaceInputStream(InputStream aInputStream, String aFindBytes, String aReplaceBytes, Charset aCharset) {
        this(aInputStream, aFindBytes.getBytes(aCharset), aReplaceBytes.getBytes(aCharset));
    }

    @Override
    public int read() throws IOException {
        if (this._status.hasReadBuffer()) {
            int theRead = this._status.readBytes[this._status.readIndex];
            ++this._status.readIndex;
            return theRead;
        }
        if (this._status.hasReplaceBuffer()) {
            byte theRead = this._replaceBytes[this._status.replaceIndex];
            ++this._status.replaceIndex;
            return theRead;
        }
        for (int i = 0; i < this._findBytes.length; ++i) {
            int eRead;
            this._status.readBytes[i] = eRead = this._inputStream.read();
            if ((byte)eRead == this._findBytes[i]) continue;
            if (i == 0) {
                return eRead;
            }
            this._status.readIndex = 0;
            this._status.readLength = i + 1;
            return this.read();
        }
        this._status.replaceIndex = 0;
        return this.read();
    }

    @Override
    public int available() throws IOException {
        int theAvailableBytes = this._status.getReadBuffer() + this._status.getReplaceBuffer();
        return this._inputStream.available() + theAvailableBytes;
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
    }

    @Override
    public synchronized void mark(int aReadlimit) {
        this._inputStream.mark(aReadlimit);
        if (this.markSupported()) {
            this._mark = (Status)this._status.clone();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this._inputStream.reset();
            if (this.markSupported() && this._mark != null) {
                this._status = this._mark;
            }
        }
        catch (IOException e) {
            this._mark = null;
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    private class Status
    implements Clonable {
        int replaceIndex = -1;
        int[] readBytes;
        int readIndex = -1;
        int readLength = 0;

        Status() {
        }

        Status(int[] aReadBytes, int aReadIndex, int aReadLength, int aReplaceIndex) {
            this.readBytes = aReadBytes;
            this.readIndex = aReadIndex;
            this.readLength = aReadLength;
            this.replaceIndex = aReplaceIndex;
        }

        public boolean hasReadBuffer() {
            return this.readIndex != -1 && this.readIndex < this.readLength;
        }

        public int getReadBuffer() {
            return this.hasReadBuffer() ? this.readLength - (this.readIndex + 1) : 0;
        }

        public boolean hasReplaceBuffer() {
            return this.replaceIndex != -1 && this.replaceIndex < ReplaceInputStream.this._replaceBytes.length;
        }

        public int getReplaceBuffer() {
            if (this.hasReplaceBuffer()) {
                return ReplaceInputStream.this._replaceBytes.length - (this.replaceIndex + 1);
            }
            return 0;
        }

        public Object clone() {
            return new Status(this.readBytes, this.readIndex, this.readLength, this.replaceIndex);
        }
    }
}

