/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import org.refcodes.io.AbstractBytesTransmitter;
import org.refcodes.io.ConnectionBytesTransmitter;
import org.refcodes.io.LoopbackBytesReceiver;

public class LoopbackBytesTransmitter
extends AbstractBytesTransmitter
implements ConnectionBytesTransmitter<LoopbackBytesReceiver> {
    private LoopbackBytesReceiver _loopbackReceiver;

    public boolean isOpenable(LoopbackBytesReceiver aLoopbackReceiver) {
        return !this.isOpened() && aLoopbackReceiver != null;
    }

    public synchronized void open(LoopbackBytesReceiver aLoopbackReceiver) throws IOException {
        if (this.isOpened()) {
            if (this._loopbackReceiver == aLoopbackReceiver && this._loopbackReceiver.isOpened()) {
                return;
            }
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + String.valueOf(this.getConnectionStatus()) + ".");
        }
        super.open();
        this._loopbackReceiver = aLoopbackReceiver;
        if (this._loopbackReceiver.isOpenable(this)) {
            this._loopbackReceiver.open(this);
        }
    }

    @Override
    public synchronized void transmitByte(byte aByte) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aByte + "> as the connection is NOT OPEN; connection status is " + String.valueOf(this.getConnectionStatus()) + ".");
        }
        this._loopbackReceiver.pushDatagram(aByte);
    }

    @Override
    public void transmitBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + String.valueOf(aBytes) + "> as the connection is NOT OPEN; connection status is " + String.valueOf(this.getConnectionStatus()) + ".");
        }
        this._loopbackReceiver.pushDatagrams(aBytes, aOffset, aLength);
    }

    @Override
    public void transmitBytes(byte[] aBytes) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + String.valueOf(aBytes) + "> as the connection is NOT OPEN; connection status is " + String.valueOf(this.getConnectionStatus()) + ".");
        }
        this._loopbackReceiver.pushDatagrams(aBytes);
    }

    @Override
    public void flush() throws IOException {
    }

    public void close() throws IOException {
        super.close();
        if (this._loopbackReceiver != null && !this._loopbackReceiver.isClosed()) {
            this._loopbackReceiver.close();
            this._loopbackReceiver = null;
        }
    }
}

