/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.SystemProperty;

public class HexOutputStream
extends OutputStream {
    private static final byte[] HEX_SPACE = " ".getBytes();
    private long _count = 0L;
    private final String _lineBreak;
    private final int _lineLength;
    private final OutputStream _outputStream;
    private final boolean _isPrefixBytes;
    private final boolean _isFlushLineBreak;

    public HexOutputStream(OutputStream aOutputStream) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineLength = -1;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = true;
        this._isFlushLineBreak = false;
    }

    public HexOutputStream(OutputStream aOutputStream, boolean isPrefixBytes) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineLength = -1;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = isPrefixBytes;
        this._isFlushLineBreak = false;
    }

    public HexOutputStream(OutputStream aOutputStream, int aLineLength, String aLineBreak) {
        this._lineBreak = aLineBreak;
        this._lineLength = aLineLength;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = true;
        this._isFlushLineBreak = false;
    }

    public HexOutputStream(OutputStream aOutputStream, int aLineLength, String aLineBreak, boolean isPrefixBytes) {
        this._lineBreak = aLineBreak;
        this._lineLength = aLineLength;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = isPrefixBytes;
        this._isFlushLineBreak = false;
    }

    public HexOutputStream(OutputStream aOutputStream, int aLineLength) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineLength = aLineLength;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = true;
        this._isFlushLineBreak = false;
    }

    public HexOutputStream(OutputStream aOutputStream, int aLineLength, boolean isPrefixBytes) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineLength = aLineLength;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = isPrefixBytes;
        this._isFlushLineBreak = false;
    }

    public HexOutputStream(OutputStream aOutputStream, boolean isPrefixBytes, boolean isFlushLineBreak) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineLength = -1;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = isPrefixBytes;
        this._isFlushLineBreak = isFlushLineBreak;
    }

    public HexOutputStream(OutputStream aOutputStream, int aLineLength, String aLineBreak, boolean isPrefixBytes, boolean isFlushLineBreak) {
        this._lineBreak = aLineBreak;
        this._lineLength = aLineLength;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = isPrefixBytes;
        this._isFlushLineBreak = isFlushLineBreak;
    }

    public HexOutputStream(OutputStream aOutputStream, int aLineLength, boolean isPrefixBytes, boolean isFlushLineBreak) {
        this._lineBreak = SystemProperty.LINE_SEPARATOR.getValue();
        this._lineLength = aLineLength;
        this._outputStream = aOutputStream;
        this._isPrefixBytes = isPrefixBytes;
        this._isFlushLineBreak = isFlushLineBreak;
    }

    @Override
    public void write(int aByte) throws IOException {
        ++this._count;
        String theHexString = NumericalUtility.toHexString((int)aByte, (boolean)this._isPrefixBytes);
        this._outputStream.write(theHexString.getBytes());
        if (this._lineLength != -1 && this._count % (long)this._lineLength == 0L) {
            this._outputStream.write(this._lineBreak.getBytes());
            this._count = 0L;
        } else {
            this._outputStream.write(HEX_SPACE);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._isFlushLineBreak) {
            this._outputStream.write(this._lineBreak.getBytes());
            this._count = 0L;
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._lineLength != -1) {
            if (this._count % (long)this._lineLength != 0L) {
                this._outputStream.write(this._lineBreak.getBytes());
                this._count = 0L;
            }
            super.close();
        }
    }
}

