/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.Serializable;
import org.refcodes.component.Closable;
import org.refcodes.io.AbstractDatagramsReceiver;
import org.refcodes.io.DatagramsDestination;

public class DatagramsReceiverDecorator<DATA extends Serializable>
extends AbstractDatagramsReceiver<DATA> {
    private final DatagramsDestination<DATA> _provider;

    public DatagramsReceiverDecorator(DatagramsDestination<DATA> aProvider) {
        this._provider = aProvider;
        try {
            this.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public DATA receive() throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        return this._provider.receive();
    }

    @Override
    public synchronized int available() throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        throw new UnsupportedOperationException("The underlying type <" + DatagramsDestination.class.getName() + "> does not support means to determine avaialbility!");
    }

    @Override
    public DATA[] receiveAll() throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        return this._provider.receiveAll();
    }

    @Override
    public DATA[] receive(int aLength) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        return this._provider.receive(aLength);
    }

    @Override
    public void close() throws IOException {
        if (this._provider instanceof Closable) {
            ((Closable)this._provider).close();
        }
        super.close();
    }
}

