/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BoundedInputStream
extends InputStream {
    private final int _totalBytes;
    private int _bytesRead = 0;
    private final InputStream _inputStream;
    private int _mark = -1;

    public BoundedInputStream(InputStream aInputStream, int aTotalBytes) {
        this._inputStream = aInputStream;
        this._totalBytes = aTotalBytes;
    }

    @Override
    public int read() throws IOException {
        if (this._bytesRead >= this._totalBytes) {
            throw new IOException("The number of bytes <" + this._bytesRead + "> being read reached the length limit <" + this._totalBytes + "> to which the underlying input stream is bounded.");
        }
        int theResult = this._inputStream.read();
        ++this._bytesRead;
        return theResult;
    }

    public int getTotalBytes() {
        return this._totalBytes;
    }

    public int getBytesRead() {
        return this._bytesRead;
    }

    public int getBytesAvaialable() {
        return this._totalBytes - this._bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this._inputStream.mark(readlimit);
        if (this.markSupported()) {
            this._mark = this._bytesRead;
        }
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this._inputStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this._inputStream.read(b);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this._inputStream.readAllBytes();
    }

    @Override
    public int readNBytes(byte[] arg0, int arg1, int arg2) throws IOException {
        return this._inputStream.readNBytes(arg0, arg1, arg2);
    }

    @Override
    public synchronized void reset() throws IOException {
        this._inputStream.reset();
        if (this.markSupported() && this._mark != -1) {
            this._bytesRead = this._mark;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this._inputStream.skip(n);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this._inputStream.transferTo(out);
    }
}

