/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedList;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.io.DatagramsReceiver;
import org.refcodes.io.SerializableObjectInputStream;

public abstract class AbstractInputStreamReceiver<DATA extends Serializable>
extends AbstractConnectableAutomaton
implements DatagramsReceiver<DATA> {
    private final LinkedList<DATA> _datagramQueue = new LinkedList();
    private ObjectInputStream _inputStream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        if (!this._datagramQueue.isEmpty()) {
            return this._datagramQueue.size();
        }
        if (this.isClosed()) {
            return 0;
        }
        try {
            Object theObject = this._inputStream.readObject();
            if (theObject == null) {
                if (this.isClosed()) {
                    return 0;
                }
                this.close();
                LinkedList<DATA> linkedList = this._datagramQueue;
                synchronized (linkedList) {
                    this._datagramQueue.notifyAll();
                }
                return 0;
            }
            this._datagramQueue.add((Serializable)theObject);
            return this._datagramQueue.size();
        }
        catch (IOException ioe) {
            if (this.isClosed()) {
                return 0;
            }
            LinkedList<DATA> linkedList = this._datagramQueue;
            synchronized (linkedList) {
                this._datagramQueue.notifyAll();
            }
            try {
                if (AbstractInputStreamReceiver.isThrownAsOfAlreadyClosed((IOException)ioe)) {
                    super.close();
                } else {
                    this.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to test datagram availability (connection status is <" + String.valueOf(this.getConnectionStatus()) + ">).", e);
            }
            throw new IOException("Unable to test datagram availability (connection status is <" + String.valueOf(this.getConnectionStatus()) + ">).", ioe);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Datagram read is of unknown type (connection status is <" + String.valueOf(this.getConnectionStatus()) + ">).", e);
        }
    }

    @Override
    public DATA receive() throws IOException {
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        if (!this.hasAvailable()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        Serializable theDatagram = (Serializable)this._datagramQueue.poll();
        while (theDatagram == null) {
            if (this.hasAvailable()) continue;
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + String.valueOf(this.getConnectionStatus()) + ">.");
        }
        return (DATA)theDatagram;
    }

    public synchronized void close() throws IOException {
        block3: {
            if (!this.isClosed()) {
                super.close();
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    if (AbstractInputStreamReceiver.isThrownAsOfAlreadyClosed((IOException)e)) break block3;
                    throw new IOException("Unable to close receiver (connection status is <" + String.valueOf(this.getConnectionStatus()) + ">).", e);
                }
            }
        }
    }

    protected synchronized void open(InputStream aInputStream) throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + String.valueOf(this.getConnectionStatus()) + ".");
        }
        try {
            this._inputStream = !(aInputStream instanceof BufferedInputStream) ? new SerializableObjectInputStream(new BufferedInputStream(aInputStream)) : new SerializableObjectInputStream(aInputStream);
        }
        catch (IOException aException) {
            throw new IOException("Unable to open the I/O stream receiver as of a causing exception.", aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    protected boolean isOpenable(InputStream aInputStream) {
        return aInputStream == null ? false : !this.isOpened();
    }
}

