/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.refcodes.io.SerializableListIterator;

public class SerializableIterator<T>
implements Iterator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Iterator<T> _iterator = null;
    private List<T> _list = new ArrayList<T>();

    public SerializableIterator() {
    }

    public SerializableIterator(Iterator<T> aIterator) {
        assert (aIterator != null);
        while (aIterator.hasNext()) {
            Object eObj = aIterator.next();
            if (eObj instanceof ListIterator && !(eObj instanceof SerializableListIterator)) {
                eObj = new SerializableListIterator((ListIterator)eObj);
            } else if (eObj instanceof Iterator && !(eObj instanceof SerializableIterator)) {
                eObj = new SerializableIterator<T>((Iterator)eObj);
            }
            this._list.add(eObj);
        }
    }

    @Override
    public boolean hasNext() {
        this.lazyInit();
        return this._iterator.hasNext();
    }

    @Override
    public T next() {
        this.lazyInit();
        return this._iterator.next();
    }

    @Override
    public void remove() {
        this.lazyInit();
        this._iterator.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this._iterator == null) {
            SerializableIterator serializableIterator = this;
            synchronized (serializableIterator) {
                if (this._iterator == null) {
                    this._iterator = this._list.iterator();
                }
            }
        }
    }
}

