/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.data.IoTimeout;

public class BlockingInputStream
extends InputStream {
    private InputStream _inputStream;

    public BlockingInputStream(InputStream aInputStream) {
        this._inputStream = aInputStream;
    }

    @Override
    public int read() throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(IoTimeout.MIN.getTimeInMs());
            }
            catch (InterruptedException interruptedException) {}
        }
        return this._inputStream.read();
    }

    @Override
    public int read(byte[] aB) throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(IoTimeout.MIN.getTimeInMs());
            }
            catch (InterruptedException interruptedException) {}
        }
        return this._inputStream.read(aB);
    }

    @Override
    public int read(byte[] aB, int aOff, int aLen) throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(IoTimeout.MIN.getTimeInMs());
            }
            catch (InterruptedException interruptedException) {}
        }
        return this._inputStream.read(aB, aOff, aLen);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(IoTimeout.MIN.getTimeInMs());
            }
            catch (InterruptedException interruptedException) {}
        }
        return this._inputStream.readAllBytes();
    }

    @Override
    public int readNBytes(byte[] aB, int aOff, int aLen) throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(IoTimeout.MIN.getTimeInMs());
            }
            catch (InterruptedException interruptedException) {}
        }
        return this._inputStream.readNBytes(aB, aOff, aLen);
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this._inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }
}

