/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.GridHeightAccessor;
import org.refcodes.graphical.GridWidthAccessor;
import org.refcodes.graphical.Position;

public interface GridDimension
extends GridHeightAccessor,
GridWidthAccessor {
    default public boolean isInBounds(Position aPosition) {
        return this.isInBounds(aPosition.getPositionX(), aPosition.getPositionY());
    }

    default public boolean isInBounds(int aPositionX, int aPositionY) {
        return aPositionX < this.getGridWidth() && aPositionY < this.getGridHeight() && aPositionX >= 0 && aPositionY >= 0;
    }

    default public boolean isInWidth(int aPositionX) {
        return aPositionX < this.getGridWidth() && aPositionX >= 0;
    }

    default public boolean isInHeight(int aPositionY) {
        return aPositionY < this.getGridHeight() && aPositionY >= 0;
    }

    public static boolean equals(GridDimension aGridDimensionA, GridDimension aGridDimensionB) {
        return aGridDimensionA.getGridWidth() == aGridDimensionB.getGridWidth() && aGridDimensionA.getGridHeight() == aGridDimensionB.getGridHeight();
    }

    public static interface GridDimensionProperty
    extends GridDimensionAccessor,
    GridDimensionMutator,
    GridWidthAccessor.GridWidthProperty,
    GridHeightAccessor.GridHeightProperty {
        default public GridDimension letGridDimension(GridDimension aGridDimension) {
            this.setGridDimension(aGridDimension);
            return aGridDimension;
        }

        default public Dimension letGridDimension(Dimension aDimension) {
            this.setGridDimension(aDimension);
            return aDimension;
        }

        default public GridDimension letGridDimension(final int aGridWidth, final int aGridHeight) {
            this.setGridDimension(aGridWidth, aGridHeight);
            return new GridDimension(){
                final /* synthetic */ GridDimensionProperty this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int getGridWidth() {
                    return aGridWidth;
                }

                @Override
                public int getGridHeight() {
                    return aGridHeight;
                }
            };
        }
    }

    public static interface GridDimensionBuilder<B extends GridDimensionBuilder<B>>
    extends GridWidthAccessor.GridWidthBuilder<B>,
    GridHeightAccessor.GridHeightBuilder<B> {
        public B withGridDimension(int var1, int var2);

        public B withGridDimension(GridDimension var1);

        public B withGridDimension(Dimension var1);
    }

    public static interface GridDimensionMutator
    extends GridHeightAccessor.GridHeightMutator,
    GridWidthAccessor.GridWidthMutator {
        public void setGridDimension(int var1, int var2);

        public void setGridDimension(GridDimension var1);

        public void setGridDimension(Dimension var1);
    }

    public static interface GridDimensionAccessor
    extends GridDimension {
    }
}

