/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixelImpl;
import org.refcodes.graphical.RgbPixmap;

public class RgbPixmapImpl
implements RgbPixmap {
    protected RgbPixel[][] _pixels = null;

    public RgbPixmapImpl() {
    }

    public RgbPixmapImpl(RgbPixel[][] rgbPixelArray) {
        this._pixels = rgbPixelArray;
    }

    public RgbPixmapImpl(int n, int n2) {
        this._pixels = new RgbPixel[n][n2];
    }

    public RgbPixmapImpl(BufferedImage bufferedImage) {
        this(bufferedImage, -1, -1);
    }

    public RgbPixmapImpl(URL uRL) throws IOException {
        this(uRL, -1, -1);
    }

    public RgbPixmapImpl(File file) throws IOException {
        this(file, -1, -1);
    }

    public RgbPixmapImpl(InputStream inputStream) throws IOException {
        this(inputStream, -1, -1);
    }

    public RgbPixmapImpl(URL uRL, int n, int n2) throws IOException {
        this(ImageIO.read(uRL), n, n2);
    }

    public RgbPixmapImpl(File file, int n, int n2) throws IOException {
        this(new FileInputStream(file), n, n2);
    }

    public RgbPixmapImpl(InputStream inputStream, int n, int n2) throws IOException {
        this(ImageIO.read(inputStream), n, n2);
    }

    public RgbPixmapImpl(BufferedImage bufferedImage, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (n3 == -1 && n4 != -1) {
            n3 = (int)((float)n5 / (float)n6 * (float)n4);
        }
        if (n3 != -1 && n4 == -1) {
            n4 = (int)((float)n3 / (float)n5 * (float)n6);
        }
        if (n3 == -1 && n4 == -1) {
            n3 = n5;
            n4 = n6;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getType());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(n3, n4);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        bufferedImage2 = affineTransformOp.filter(bufferedImage, bufferedImage2);
        this._pixels = new RgbPixel[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this._pixels[i][j] = new RgbPixelImpl(bufferedImage.getRGB(i, j));
            }
        }
    }

    public RgbPixel[][] getPixels() {
        return this._pixels;
    }

    @Override
    public int getWidth() {
        return this._pixels.length;
    }

    @Override
    public int getHeight() {
        return this._pixels[0].length;
    }

    @Override
    public RgbPixel getPixelAt(int n, int n2) throws IndexOutOfBoundsException {
        return this._pixels[n][n2];
    }
}

