/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.CharSet;
import org.refcodes.generator.IdGenerator;

public class AlphabetCounter
implements IdGenerator {
    private char[] _alphabet;
    private int _base;
    private int[] _counter;
    private char[] _digits;
    private Map<Character, Integer> _indexOf = new HashMap<Character, Integer>();
    private Map<Integer, Character> _charAt = new HashMap<Integer, Character>();
    private int _minLength;
    private int _maxLength;

    public AlphabetCounter(String string) {
        this(string.toCharArray());
    }

    public AlphabetCounter(char[] cArray) {
        this(cArray, Character.toString(cArray[0]));
    }

    public AlphabetCounter(Collection<Character> collection) {
        this(AlphabetCounter.toCharArray(collection));
    }

    public AlphabetCounter(CharSet charSet) {
        this(charSet.getCharSet());
    }

    public AlphabetCounter(String string, String string2) {
        this(string.toCharArray(), string2);
    }

    public AlphabetCounter(Collection<Character> collection, String string) {
        this(AlphabetCounter.toCharArray(collection), string);
    }

    public AlphabetCounter(CharSet charSet, String string) {
        this(charSet.getCharSet(), string);
    }

    public AlphabetCounter(char[] cArray, String string) {
        this(cArray, string, 1);
    }

    public AlphabetCounter(String string, int n) {
        this(string.toCharArray(), n);
    }

    public AlphabetCounter(char[] cArray, int n) {
        this(cArray, Character.toString(cArray[0]), n);
    }

    public AlphabetCounter(Collection<Character> collection, int n) {
        this(AlphabetCounter.toCharArray(collection), n);
    }

    public AlphabetCounter(CharSet charSet, int n) {
        this(charSet.getCharSet(), n);
    }

    public AlphabetCounter(String string, String string2, int n) {
        this(string.toCharArray(), string2, n);
    }

    public AlphabetCounter(Collection<Character> collection, String string, int n) {
        this(AlphabetCounter.toCharArray(collection), string, n);
    }

    public AlphabetCounter(CharSet charSet, String string, int n) {
        this(charSet.getCharSet(), string, n);
    }

    public AlphabetCounter(char[] cArray, String string, int n) {
        this(cArray, string, n, -1);
    }

    public AlphabetCounter(String string, int n, int n2) {
        this(string.toCharArray(), n, n2);
    }

    public AlphabetCounter(char[] cArray, int n, int n2) {
        this(cArray, Character.toString(cArray[0]), n, n2);
    }

    public AlphabetCounter(Collection<Character> collection, int n, int n2) {
        this(AlphabetCounter.toCharArray(collection), n, n2);
    }

    public AlphabetCounter(CharSet charSet, int n, int n2) {
        this(charSet.getCharSet(), n, n2);
    }

    public AlphabetCounter(String string, String string2, int n, int n2) {
        this(string.toCharArray(), string2, n, n2);
    }

    public AlphabetCounter(Collection<Character> collection, String string, int n, int n2) {
        this(AlphabetCounter.toCharArray(collection), string, n, n2);
    }

    public AlphabetCounter(CharSet charSet, String string, int n, int n2) {
        this(charSet.getCharSet(), string, n, n2);
    }

    public AlphabetCounter(char[] cArray, String string, int n, int n2) {
        int n3;
        if (string == null || string.length() == 0) {
            string = Character.toString(cArray[0]);
        }
        while (string.length() > 1 && string.charAt(0) == cArray[0]) {
            string = string.substring(1);
        }
        for (n3 = 0; n3 < cArray.length; ++n3) {
            this._indexOf.put(Character.valueOf(cArray[n3]), n3);
            this._charAt.put(n3, Character.valueOf(cArray[n3]));
        }
        for (n3 = 0; n3 < string.length(); ++n3) {
            if (this._indexOf.containsKey(Character.valueOf(string.charAt(n3)))) continue;
            throw new IllegalArgumentException("The provided start value \"" + string + "\" must only contain values found in the alphabet <" + Arrays.toString(cArray) + "> !");
        }
        this._alphabet = cArray;
        this._base = cArray.length;
        this._counter = new int[string.length()];
        this._minLength = n;
        this._maxLength = n2;
        this._digits = new char[this._counter.length > n ? this._counter.length : n];
        for (n3 = 0; n3 < this._counter.length; ++n3) {
            this._counter[n3] = this._indexOf.get(Character.valueOf(string.charAt(string.length() - 1 - n3)));
        }
    }

    @Override
    public boolean hasNext() {
        if (this._maxLength == -1) {
            return true;
        }
        return this._maxLength >= this._digits.length;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("The next elelent would exceed the maximum spcified length <" + this._maxLength + ">!");
        }
        boolean bl = false;
        for (int i = 0; i < (this._counter.length > this._minLength ? this._counter.length : this._minLength); ++i) {
            if (i < this._counter.length) {
                this._digits[this._digits.length - 1 - i] = this._charAt.get(this._counter[i]).charValue();
                if (i != 0 && !bl) continue;
                int n = i;
                this._counter[n] = this._counter[n] + 1;
                if (this._counter[i] >= this._base) {
                    this._counter[i] = 0;
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            this._digits[this._digits.length - 1 - i] = this._charAt.get(0).charValue();
        }
        if (bl) {
            String string = new String(this._digits);
            this._counter = Arrays.copyOf(this._counter, this._counter.length + 1);
            this._counter[this._counter.length - 1] = 1;
            if (this._counter.length > this._minLength) {
                this._digits = new char[this._counter.length];
            }
            return string;
        }
        return new String(this._digits);
    }

    public char[] getAlphabet() {
        return this._alphabet;
    }

    private static char[] toCharArray(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        Iterator<Character> iterator = collection.iterator();
        while (iterator.hasNext()) {
            char c;
            cArray[n] = c = iterator.next().charValue();
            ++n;
        }
        return cArray;
    }
}

