/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.exception;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.refcodes.exception.MessageStrategy;

public enum MessageDetails implements Function<Throwable, String>
{
    PLAIN(e -> e.getMessage()),
    PLAIN_LOCALIZED(e -> e.getLocalizedMessage()),
    SHORT(e -> MessageDetails.toMessage(e, true, MessageStrategy.MESSAGE)),
    SHORT_LOCALIZED(e -> MessageDetails.toMessage(e, true, MessageStrategy.LOCALIZED_MESSAGE)),
    FULL(e -> MessageDetails.toMessage(e, false, MessageStrategy.MESSAGE)),
    FULL_LOCALIZED(e -> MessageDetails.toMessage(e, false, MessageStrategy.LOCALIZED_MESSAGE));

    public static final String CAUSED_BY = "Caused by";
    public static final String ALSO_NOTABLE = "Also notable";
    public static final String POSSIBLE_CAUSE = "Possible cause";
    private Function<Throwable, String> _function;

    private MessageDetails(Function<Throwable, String> aFunction) {
        this._function = aFunction;
    }

    @Override
    public String apply(Throwable eException) {
        return this._function.apply(eException);
    }

    private static String toMessage(Throwable aException, boolean isLeafsOnly, MessageStrategy aMessageStrategy) {
        return MessageDetails.toMessage(aException, isLeafsOnly, aMessageStrategy, new HashSet<Throwable>());
    }

    private static String toMessage(Throwable aException, boolean isLeafsOnly, MessageStrategy aMessageStrategy, Set<Throwable> aVistedExceptions) {
        if (aVistedExceptions.contains(aException)) {
            return "";
        }
        aVistedExceptions.add(aException);
        Object theMessage = "";
        if (!isLeafsOnly || aException.getCause() == null || aException.getCause() == aException) {
            theMessage = MessageDetails.toNormalizedMessage(aMessageStrategy.getMessage(aException));
        }
        if (aException.getSuppressed() != null && aException.getSuppressed().length != 0) {
            if (((String)theMessage).length() != 0) {
                theMessage = (String)theMessage + " Also notable: ";
            }
            boolean isFirst = true;
            for (Throwable e : aException.getSuppressed()) {
                if (isFirst) {
                    isFirst = false;
                } else if (((String)theMessage).length() != 0) {
                    theMessage = (String)theMessage + " ";
                }
                theMessage = (String)theMessage + MessageDetails.toMessage(e, isLeafsOnly, aMessageStrategy, aVistedExceptions);
            }
        }
        if (aException.getCause() != null && aException.getCause() != aException) {
            if (((String)theMessage).length() != 0) {
                theMessage = (String)theMessage + " Caused by: ";
            }
            theMessage = (String)theMessage + MessageDetails.toMessage(aException.getCause(), isLeafsOnly, aMessageStrategy, aVistedExceptions);
        }
        return theMessage != null && ((String)theMessage).length() != 0 ? theMessage : aMessageStrategy.getMessage(aException);
    }

    private static String toNormalizedMessage(String aMessage) {
        if (aMessage == null) {
            aMessage = "";
        }
        if (((String)(aMessage = ((String)aMessage).trim())).length() > 0) {
            if (Character.isLowerCase(((String)aMessage).charAt(0))) {
                aMessage = Character.toUpperCase(((String)aMessage).charAt(0)) + ((String)aMessage).substring(1);
            }
            if (!MessageDetails.isEndOfSentence(((String)aMessage).charAt(((String)aMessage).length() - 1))) {
                aMessage = (String)aMessage + ".";
            }
        }
        return aMessage;
    }

    private static boolean isEndOfSentence(char aChar) {
        return switch (aChar) {
            case '?' -> true;
            case '!' -> true;
            case '.' -> true;
            default -> false;
        };
    }
}

