/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.refcodes.controlflow.ManagedExecutorService;
import org.refcodes.controlflow.TweakableThreadFactory;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.Text;

public final class ControlFlowUtility {
    private ControlFlowUtility() {
    }

    public static void throwIllegalStateException(boolean isIllegalState) {
        if (isIllegalState) {
            throw new IllegalStateException(Text.ILLEGAL_STATE.getText());
        }
    }

    public static void joinThreads(Collection<? extends Thread> aThreads) {
        for (Thread thread : aThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void joinThreads(Thread ... aThreads) {
        for (Thread eJoinThread : aThreads) {
            try {
                eJoinThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void joinFutures(Collection<? extends Future<?>> aFutures) {
        for (Future<?> eJoinFuture : aFutures) {
            try {
                eJoinFuture.get();
            }
            catch (Exception exception) {}
        }
    }

    public static void joinFutures(Future<?> ... aFutures) {
        for (Future<?> eJoinFuture : aFutures) {
            try {
                eJoinFuture.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object waitForFutures(Collection<? extends Future<?>> aFutures) throws ExecutionException, InterruptedException {
        Exception theException = null;
        Object theResult = null;
        for (Future<?> eJoinFuture : aFutures) {
            try {
                if (theResult == null) {
                    theResult = eJoinFuture.get();
                    continue;
                }
                eJoinFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (theException != null) continue;
                theException = e;
            }
        }
        if (theException != null) {
            if (theException instanceof ExecutionException) {
                throw (ExecutionException)theException;
            }
            if (theException instanceof InterruptedException) {
                throw (InterruptedException)theException;
            }
        }
        return theResult;
    }

    public static Object waitForFutures(Future<?> ... aFutures) throws Exception {
        Exception theException = null;
        Object theResult = null;
        for (Future<?> eJoinFuture : aFutures) {
            try {
                if (theResult == null) {
                    theResult = eJoinFuture.get();
                    continue;
                }
                eJoinFuture.get();
            }
            catch (Exception e) {
                if (theException != null) continue;
                theException = e;
            }
        }
        if (theException != null) {
            throw theException;
        }
        return theResult;
    }

    public static void shutdownGracefully(ExecutorService aExecutorService) {
        ControlFlowUtility.shutdownGracefully(aExecutorService, DaemonLoopSleepTime.NORM.getTimeMillis());
    }

    public static void shutdownGracefully(ExecutorService aExecutorService, long aTimeoutMillis) {
        aExecutorService.shutdown();
        if (aTimeoutMillis > 0L) {
            try {
                aExecutorService.awaitTermination(DaemonLoopSleepTime.NORM.getTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            aExecutorService.shutdownNow();
        }
    }

    public static ExecutorService toManagedExecutorService(ExecutorService aExecutorService) {
        if (aExecutorService instanceof ManagedExecutorService) {
            return aExecutorService;
        }
        return new ManagedExecutorService(aExecutorService);
    }

    public static ExecutorService createCachedExecutorService(boolean isDaemon) {
        if (isDaemon) {
            return Executors.newCachedThreadPool(new TweakableThreadFactory(true));
        }
        return Executors.newCachedThreadPool();
    }

    public static ScheduledExecutorService createScheduledExecutorService(int aCorePoolSize, boolean isDaemon) {
        if (isDaemon) {
            return Executors.newScheduledThreadPool(aCorePoolSize, new TweakableThreadFactory(true));
        }
        return Executors.newScheduledThreadPool(aCorePoolSize);
    }
}

