/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleComponent;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.LifecycleStatusAccessor;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;

public class LifecycleAutomatonImpl
implements LifecycleComponent.LifecycleAutomaton {
    private LifecycleStatus _lifeCycleStatus = LifecycleStatus.NONE;
    private LifecycleComponent _lifeCycleComponent = null;

    public LifecycleAutomatonImpl() {
    }

    public LifecycleAutomatonImpl(LifecycleComponent aLifecycleComponent) {
        this._lifeCycleComponent = aLifecycleComponent;
    }

    @Override
    public synchronized LifecycleStatus getLifecycleStatus() {
        return this._lifeCycleStatus;
    }

    @Override
    public synchronized void initialize() throws InitializeException {
        if (!this.isInitalizable()) {
            throw new InitializeException("Cannot initialize as the component is in status <" + this._lifeCycleStatus + "> which is not the appropriate status for initializing.");
        }
        if (this._lifeCycleComponent != null) {
            this._lifeCycleComponent.initialize();
        }
        this._lifeCycleStatus = LifecycleStatus.INITIALIZED;
    }

    @Override
    public synchronized boolean isInitalizable() {
        return this._lifeCycleStatus == LifecycleStatus.NONE || this._lifeCycleStatus == LifecycleStatus.ERROR || this.isDestroyed();
    }

    @Override
    public synchronized boolean isInitialized() {
        return this._lifeCycleStatus == LifecycleStatus.INITIALIZED;
    }

    @Override
    public synchronized boolean isStartable() {
        return this.isInitialized() || this.isStopped();
    }

    @Override
    public synchronized void start() throws StartException {
        if (!this.isStartable()) {
            throw new StartException("Cannot start as the component is in status <" + this._lifeCycleStatus + "> which is not the appropriate status for starting.");
        }
        if (this._lifeCycleComponent != null) {
            this._lifeCycleComponent.start();
        }
        this._lifeCycleStatus = LifecycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isRunning() {
        return this._lifeCycleStatus == LifecycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isPausable() {
        return this.isRunning();
    }

    @Override
    public synchronized void pause() throws PauseException {
        if (!this.isPausable()) {
            throw new PauseException("Cannot pause as the component is in status <" + this._lifeCycleStatus + "> which is not the appropriate status for pausing.");
        }
        if (this._lifeCycleComponent != null) {
            this._lifeCycleComponent.pause();
        }
        this._lifeCycleStatus = LifecycleStatus.PAUSED;
    }

    @Override
    public synchronized boolean isPaused() {
        return this._lifeCycleStatus == LifecycleStatus.PAUSED;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.isPaused();
    }

    @Override
    public synchronized void resume() throws ResumeException {
        if (!this.isResumable()) {
            throw new ResumeException("Cannot resume as the component is in status <" + this._lifeCycleStatus + "> which is not the appropriate status for resuming.");
        }
        if (this._lifeCycleComponent != null) {
            this._lifeCycleComponent.resume();
        }
        this._lifeCycleStatus = LifecycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isStoppable() {
        return this.isRunning() || this.isPaused();
    }

    @Override
    public synchronized void stop() throws StopException {
        if (!this.isStoppable()) {
            throw new StopException("Cannot stop as the component is in status <" + this._lifeCycleStatus + "> which is not the appropriate status for stopping.");
        }
        if (this._lifeCycleComponent != null) {
            this._lifeCycleComponent.stop();
        }
        this._lifeCycleStatus = LifecycleStatus.STOPPED;
    }

    @Override
    public synchronized boolean isStopped() {
        return this._lifeCycleStatus == LifecycleStatus.STOPPED;
    }

    @Override
    public synchronized boolean isDestroyable() {
        return this.isStopped();
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyable()) {
            return;
        }
        if (this._lifeCycleComponent != null) {
            this._lifeCycleComponent.destroy();
        }
        this._lifeCycleStatus = LifecycleStatus.DESTROYED;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this._lifeCycleStatus == LifecycleStatus.DESTROYED;
    }

    protected LifecycleComponent getLifecycleComponent() {
        return this._lifeCycleComponent;
    }

    protected void setLifecycleStatus(LifecycleStatus aStatus) {
        this._lifeCycleStatus = aStatus;
    }

    public static class ManualLifecycleAutomatonImpl
    extends LifecycleAutomatonImpl
    implements LifecycleStatusAccessor.LifecycleStatusMutator {
        public ManualLifecycleAutomatonImpl() {
        }

        public ManualLifecycleAutomatonImpl(LifecycleComponent aLifecycleComponent) {
            super(aLifecycleComponent);
        }

        @Override
        public void setLifecycleStatus(LifecycleStatus aStatus) {
            super.setLifecycleStatus(aStatus);
        }
    }
}

