/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.PublishSubscribeService;
import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.SubscriptionListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

public class RedissonSubscription
extends AbstractSubscription {
    private final CommandAsyncExecutor commandExecutor;
    private final PublishSubscribeService subscribeService;

    public RedissonSubscription(CommandAsyncExecutor commandExecutor, PublishSubscribeService subscribeService, MessageListener listener) {
        super(listener, null, null);
        this.commandExecutor = commandExecutor;
        this.subscribeService = subscribeService;
    }

    protected void doSubscribe(byte[] ... channels) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        final ConcurrentLinkedQueue subscribed = new ConcurrentLinkedQueue();
        for (final byte[] channel : channels) {
            if (this.subscribeService.hasEntry(new ChannelName(channel))) continue;
            CompletableFuture f = this.subscribeService.subscribe((Codec)ByteArrayCodec.INSTANCE, new ChannelName(channel), new RedisPubSubListener[]{new BaseRedisPubSubListener(){

                public void onMessage(CharSequence ch, Object message) {
                    if (!Arrays.equals(((ChannelName)ch).getName(), channel)) {
                        return;
                    }
                    byte[] m = RedissonSubscription.this.toBytes(message);
                    DefaultMessage msg = new DefaultMessage(((ChannelName)ch).getName(), m);
                    RedissonSubscription.this.getListener().onMessage((Message)msg, null);
                }

                public void onStatus(PubSubType type, CharSequence ch) {
                    if (!Arrays.equals(((ChannelName)ch).getName(), channel)) {
                        return;
                    }
                    if (RedissonSubscription.this.getListener() instanceof SubscriptionListener) {
                        subscribed.add(channel);
                    }
                    super.onStatus(type, ch);
                }
            }});
            list.add(f);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            CompletableFuture future = (CompletableFuture)object.next();
            this.commandExecutor.get(future);
        }
        for (byte[] channel : subscribed) {
            ((SubscriptionListener)this.getListener()).onChannelSubscribed(channel, 1L);
        }
    }

    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        for (byte[] channel : channels) {
            CompletableFuture f = this.subscribeService.unsubscribe(new ChannelName(channel), PubSubType.UNSUBSCRIBE);
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            f.whenComplete((r, e) -> {
                if (r != null) {
                    ((SubscriptionListener)this.getListener()).onChannelUnsubscribed(channel, 1L);
                }
            });
        }
    }

    protected void doPsubscribe(byte[] ... patterns) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        final ConcurrentLinkedQueue subscribed = new ConcurrentLinkedQueue();
        for (final byte[] channel : patterns) {
            if (this.subscribeService.hasEntry(new ChannelName(channel))) continue;
            CompletableFuture f = this.subscribeService.psubscribe(new ChannelName(channel), (Codec)ByteArrayCodec.INSTANCE, new RedisPubSubListener[]{new BaseRedisPubSubListener(){

                public void onPatternMessage(CharSequence pattern, CharSequence ch, Object message) {
                    if (!Arrays.equals(((ChannelName)pattern).getName(), channel)) {
                        return;
                    }
                    byte[] m = RedissonSubscription.this.toBytes(message);
                    DefaultMessage msg = new DefaultMessage(((ChannelName)ch).getName(), m);
                    RedissonSubscription.this.getListener().onMessage((Message)msg, ((ChannelName)pattern).getName());
                }

                public void onStatus(PubSubType type, CharSequence pattern) {
                    if (!Arrays.equals(((ChannelName)pattern).getName(), channel)) {
                        return;
                    }
                    if (RedissonSubscription.this.getListener() instanceof SubscriptionListener) {
                        subscribed.add(channel);
                    }
                    super.onStatus(type, pattern);
                }
            }});
            list.add(f);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            CompletableFuture future = (CompletableFuture)object.next();
            this.commandExecutor.get(future);
        }
        for (byte[] channel : subscribed) {
            ((SubscriptionListener)this.getListener()).onPatternSubscribed(channel, 1L);
        }
    }

    private byte[] toBytes(Object message) {
        if (message instanceof String) {
            return ((String)message).getBytes();
        }
        return (byte[])message;
    }

    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        for (byte[] pattern : patterns) {
            CompletableFuture f = this.subscribeService.unsubscribe(new ChannelName(pattern), PubSubType.PUNSUBSCRIBE);
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            f.whenComplete((r, e) -> {
                if (r != null) {
                    ((SubscriptionListener)this.getListener()).onPatternUnsubscribed(pattern, 1L);
                }
            });
        }
    }

    protected void doClose() {
        this.doUnsubscribe(false, (byte[][])this.getChannels().toArray((T[])new byte[this.getChannels().size()][]));
        this.doPUnsubscribe(false, (byte[][])this.getPatterns().toArray((T[])new byte[this.getPatterns().size()][]));
    }
}

