/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.redisson.api.RFuture;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.connection.ConnectionManager;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveSubscription;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class RedissonReactiveSubscription
implements ReactiveSubscription {
    private final Map<ChannelName, PubSubConnectionEntry> channels = new ConcurrentHashMap<ChannelName, PubSubConnectionEntry>();
    private final Map<ChannelName, Collection<PubSubConnectionEntry>> patterns = new ConcurrentHashMap<ChannelName, Collection<PubSubConnectionEntry>>();
    private final ListenableCounter monosListener = new ListenableCounter();
    private final PublishSubscribeService subscribeService;
    private final AtomicReference<Flux<ReactiveSubscription.Message<ByteBuffer, ByteBuffer>>> flux = new AtomicReference();
    private volatile Disposable disposable;

    public RedissonReactiveSubscription(ConnectionManager connectionManager) {
        this.subscribeService = connectionManager.getSubscribeService();
    }

    public Mono<Void> subscribe(ByteBuffer ... channels) {
        this.monosListener.acquire();
        return Mono.defer(() -> {
            RedissonPromise result = new RedissonPromise();
            result.onComplete((r, ex) -> this.monosListener.release());
            CountableListener listener = new CountableListener((RPromise)result, null, channels.length);
            for (ByteBuffer channel : channels) {
                ChannelName cn = this.toChannelName(channel);
                RFuture f = this.subscribeService.subscribe((Codec)ByteArrayCodec.INSTANCE, cn, new RedisPubSubListener[0]);
                f.onComplete((res, e) -> this.channels.put(cn, (PubSubConnectionEntry)res));
                f.onComplete((BiConsumer)listener);
            }
            return Mono.fromFuture((CompletableFuture)result);
        });
    }

    protected ChannelName toChannelName(ByteBuffer channel) {
        return new ChannelName(RedissonBaseReactive.toByteArray(channel));
    }

    public Mono<Void> pSubscribe(ByteBuffer ... patterns) {
        this.monosListener.acquire();
        return Mono.defer(() -> {
            RedissonPromise result = new RedissonPromise();
            result.onComplete((r, ex) -> this.monosListener.release());
            CountableListener listener = new CountableListener((RPromise)result, null, patterns.length);
            for (ByteBuffer channel : patterns) {
                ChannelName cn = this.toChannelName(channel);
                RFuture f = this.subscribeService.psubscribe(cn, (Codec)ByteArrayCodec.INSTANCE, new RedisPubSubListener[0]);
                f.onComplete((res, e) -> this.patterns.put(cn, (Collection<PubSubConnectionEntry>)res));
                f.onComplete((BiConsumer)listener);
            }
            return Mono.fromFuture((CompletableFuture)result);
        });
    }

    public Mono<Void> unsubscribe() {
        return this.unsubscribe((ByteBuffer[])this.channels.keySet().stream().map(b -> ByteBuffer.wrap(b.getName())).distinct().toArray(ByteBuffer[]::new));
    }

    public Mono<Void> unsubscribe(ByteBuffer ... channels) {
        this.monosListener.acquire();
        return Mono.defer(() -> {
            RedissonPromise result = new RedissonPromise();
            result.onComplete((r, ex) -> this.monosListener.release());
            CountableListener listener = new CountableListener((RPromise)result, null, channels.length);
            for (ByteBuffer channel : channels) {
                ChannelName cn = this.toChannelName(channel);
                RFuture f = this.subscribeService.unsubscribe(cn, PubSubType.UNSUBSCRIBE);
                f.onComplete((res, e) -> {
                    Map<ChannelName, PubSubConnectionEntry> map = this.channels;
                    synchronized (map) {
                        PubSubConnectionEntry entry = this.channels.get(cn);
                        if (!entry.hasListeners(cn)) {
                            this.channels.remove(cn);
                        }
                    }
                });
                f.onComplete((BiConsumer)listener);
            }
            return Mono.fromFuture((CompletableFuture)result);
        });
    }

    public Mono<Void> pUnsubscribe() {
        return this.unsubscribe((ByteBuffer[])this.patterns.keySet().stream().map(b -> ByteBuffer.wrap(b.getName())).distinct().toArray(ByteBuffer[]::new));
    }

    public Mono<Void> pUnsubscribe(ByteBuffer ... patterns) {
        this.monosListener.acquire();
        return Mono.defer(() -> {
            RedissonPromise result = new RedissonPromise();
            result.onComplete((r, ex) -> this.monosListener.release());
            CountableListener listener = new CountableListener((RPromise)result, null, patterns.length);
            for (ByteBuffer channel : patterns) {
                ChannelName cn = this.toChannelName(channel);
                RFuture f = this.subscribeService.unsubscribe(cn, PubSubType.PUNSUBSCRIBE);
                f.onComplete((res, e) -> {
                    Map<ChannelName, Collection<PubSubConnectionEntry>> map = this.patterns;
                    synchronized (map) {
                        Collection<PubSubConnectionEntry> entries = this.patterns.get(cn);
                        entries.stream().filter(en -> en.hasListeners(cn)).forEach(ee -> this.patterns.remove(cn));
                    }
                });
                f.onComplete((BiConsumer)listener);
            }
            return Mono.fromFuture((CompletableFuture)result);
        });
    }

    public Set<ByteBuffer> getChannels() {
        return this.channels.keySet().stream().map(b -> ByteBuffer.wrap(b.getName())).collect(Collectors.toSet());
    }

    public Set<ByteBuffer> getPatterns() {
        return this.patterns.keySet().stream().map(b -> ByteBuffer.wrap(b.getName())).collect(Collectors.toSet());
    }

    public Flux<ReactiveSubscription.Message<ByteBuffer, ByteBuffer>> receive() {
        if (this.flux.get() != null) {
            return this.flux.get();
        }
        Flux f = Flux.create(emitter -> emitter.onRequest(n -> this.monosListener.addListener(() -> {
            BaseRedisPubSubListener listener = new BaseRedisPubSubListener((FluxSink)emitter){
                final /* synthetic */ FluxSink val$emitter;
                {
                    this.val$emitter = fluxSink;
                }

                public void onPatternMessage(CharSequence pattern, CharSequence channel, Object message) {
                    if (!RedissonReactiveSubscription.this.patterns.containsKey(new ChannelName(pattern.toString()))) {
                        return;
                    }
                    this.val$emitter.next((Object)new ReactiveSubscription.PatternMessage((Object)ByteBuffer.wrap(pattern.toString().getBytes()), (Object)ByteBuffer.wrap(channel.toString().getBytes()), (Object)ByteBuffer.wrap((byte[])message)));
                }

                public void onMessage(CharSequence channel, Object msg) {
                    if (!RedissonReactiveSubscription.this.channels.containsKey(new ChannelName(channel.toString()))) {
                        return;
                    }
                    this.val$emitter.next((Object)new ReactiveSubscription.ChannelMessage((Object)ByteBuffer.wrap(channel.toString().getBytes()), (Object)ByteBuffer.wrap((byte[])msg)));
                }
            };
            this.disposable = () -> {
                for (Map.Entry<ChannelName, PubSubConnectionEntry> entry : this.channels.entrySet()) {
                    entry.getValue().removeListener(entry.getKey(), (RedisPubSubListener)listener);
                }
                for (Map.Entry<ChannelName, Object> entry : this.patterns.entrySet()) {
                    for (PubSubConnectionEntry pubSubConnectionEntry : (Collection)entry.getValue()) {
                        pubSubConnectionEntry.removeListener(entry.getKey(), (RedisPubSubListener)listener);
                    }
                }
            };
            for (Map.Entry<ChannelName, PubSubConnectionEntry> entry : this.channels.entrySet()) {
                entry.getValue().addListener(entry.getKey(), (RedisPubSubListener)listener);
            }
            for (Map.Entry<ChannelName, Object> entry : this.patterns.entrySet()) {
                for (PubSubConnectionEntry pubSubConnectionEntry : (Collection)entry.getValue()) {
                    pubSubConnectionEntry.addListener(entry.getKey(), (RedisPubSubListener)listener);
                }
            }
            emitter.onDispose(this.disposable);
        })));
        if (this.flux.compareAndSet(null, (Flux<ReactiveSubscription.Message<ByteBuffer, ByteBuffer>>)f)) {
            return f;
        }
        return this.flux.get();
    }

    public Mono<Void> cancel() {
        return this.unsubscribe().then(this.pUnsubscribe()).then(Mono.fromRunnable(() -> {
            if (this.disposable != null) {
                this.disposable.dispose();
            }
        }));
    }

    public static class ListenableCounter {
        private int state;
        private Runnable r;

        public synchronized void acquire() {
            ++this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ListenableCounter listenableCounter = this;
            synchronized (listenableCounter) {
                --this.state;
                if (this.state != 0) {
                    return;
                }
            }
            if (this.r != null) {
                this.r.run();
                this.r = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addListener(Runnable r) {
            ListenableCounter listenableCounter = this;
            synchronized (listenableCounter) {
                if (this.state != 0) {
                    this.r = r;
                    return;
                }
            }
            r.run();
        }
    }
}

