/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.ArrayList;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;

public class GeoResultsDecoder
implements MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> {
    private final Metric metric;

    public GeoResultsDecoder() {
        this(null);
    }

    public GeoResultsDecoder(Metric metric) {
        this.metric = metric;
    }

    public Decoder<Object> getDecoder(int paramNum, State state) {
        return ListMultiDecoder.RESET;
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> decode(List<Object> parts, State state) {
        ArrayList<GeoResult> result = new ArrayList<GeoResult>();
        for (Object object : parts) {
            if (object instanceof List) {
                RedisGeoCommands.GeoLocation location;
                List vals = (List)object;
                if (this.metric != null) {
                    location = new RedisGeoCommands.GeoLocation((Object)((byte[])vals.get(0)), null);
                    result.add(new GeoResult((Object)location, new Distance(((Double)vals.get(1)).doubleValue(), this.metric)));
                    continue;
                }
                location = new RedisGeoCommands.GeoLocation((Object)((byte[])vals.get(0)), (Point)vals.get(1));
                result.add(new GeoResult((Object)location, new Distance(0.0)));
                continue;
            }
            RedisGeoCommands.GeoLocation location = new RedisGeoCommands.GeoLocation((Object)((byte[])object), null);
            result.add(new GeoResult((Object)location, new Distance(0.0)));
        }
        return new GeoResults(result);
    }
}

