/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisTimeoutException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.RedisConnectionFailureException;

public class RedissonExceptionConverter
implements Converter<Exception, DataAccessException> {
    public DataAccessException convert(Exception source) {
        if (source instanceof RedisConnectionException) {
            return new RedisConnectionFailureException(source.getMessage(), (Throwable)source);
        }
        if (source instanceof RedisTimeoutException) {
            return new QueryTimeoutException(source.getMessage(), (Throwable)source);
        }
        if (source instanceof RedisException) {
            return new InvalidDataAccessApiUsageException(source.getMessage(), (Throwable)source);
        }
        if (source instanceof DataAccessException) {
            return (DataAccessException)source;
        }
        return null;
    }
}

