/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.starter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.misc.RedisURI;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.redisson.spring.starter.RedissonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.redis.autoconfigure.DataRedisAutoConfiguration;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.DataRedisProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.ReflectionUtils;

@AutoConfiguration(before={DataRedisAutoConfiguration.class})
@ConditionalOnClass(value={Redisson.class, RedisOperations.class, DataRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedissonProperties.class, DataRedisProperties.class})
public class RedissonAutoConfigurationV4 {
    @Autowired(required=false)
    private List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private DataRedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={StringRedisTemplate.class})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedissonConnectionFactory redissonConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonReactiveClient.class})
    public RedissonReactiveClient redissonReactive(RedissonClient redisson) {
        return redisson.reactive();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonRxClient.class})
    public RedissonRxClient redissonRxJava(RedissonClient redisson) {
        return redisson.rxJava();
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() throws IOException {
        ClusterServersConfig c;
        Method nodesMethod;
        String[] nodes;
        Config config;
        Method clusterMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getCluster");
        Method usernameMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getUsername");
        Method timeoutMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getTimeout");
        Method connectTimeoutMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getConnectTimeout");
        Method clientNameMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getClientName");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        String prefix = this.getPrefix();
        String username = null;
        int database = this.redisProperties.getDatabase();
        String password = this.redisProperties.getPassword();
        boolean isSentinel = false;
        boolean isCluster = false;
        ObjectProvider provider = this.ctx.getBeanProvider(DataRedisConnectionDetails.class);
        DataRedisConnectionDetails b = (DataRedisConnectionDetails)provider.getIfAvailable();
        if (b != null) {
            password = b.getPassword();
            username = b.getUsername();
            if (b.getSentinel() != null) {
                isSentinel = true;
            }
            if (b.getCluster() != null) {
                isCluster = true;
            }
        }
        Integer timeout = null;
        if (timeoutValue instanceof Duration) {
            timeout = (int)((Duration)timeoutValue).toMillis();
        } else if (timeoutValue != null) {
            timeout = (Integer)timeoutValue;
        }
        Integer connectTimeout = null;
        if (connectTimeoutMethod != null) {
            Object connectTimeoutValue = ReflectionUtils.invokeMethod((Method)connectTimeoutMethod, (Object)this.redisProperties);
            if (connectTimeoutValue != null) {
                connectTimeout = (int)((Duration)connectTimeoutValue).toMillis();
            }
        } else {
            connectTimeout = timeout;
        }
        String clientName = null;
        if (clientNameMethod != null) {
            clientName = (String)ReflectionUtils.invokeMethod((Method)clientNameMethod, (Object)this.redisProperties);
        }
        if (usernameMethod != null) {
            username = (String)ReflectionUtils.invokeMethod((Method)usernameMethod, (Object)this.redisProperties);
        }
        if (this.redissonProperties.getConfig() != null) {
            config = Config.fromYAML((String)this.redissonProperties.getConfig());
        } else if (this.redissonProperties.getFile() != null) {
            InputStream is = this.getConfigStream();
            config = Config.fromYAML((InputStream)is);
        } else if (this.redisProperties.getSentinel() != null || isSentinel) {
            nodes = new String[]{};
            String sentinelMaster = null;
            if (this.redisProperties.getSentinel() != null) {
                nodesMethod = ReflectionUtils.findMethod(DataRedisProperties.Sentinel.class, (String)"getNodes");
                Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
                nodes = nodesValue instanceof String ? this.convert(prefix, Arrays.asList(((String)nodesValue).split(","))) : this.convert(prefix, (List)nodesValue);
                sentinelMaster = this.redisProperties.getSentinel().getMaster();
            }
            String sentinelUsername = null;
            String sentinelPassword = null;
            if (b != null && b.getSentinel() != null) {
                database = b.getSentinel().getDatabase();
                sentinelMaster = b.getSentinel().getMaster();
                nodes = this.convertNodes(prefix, b.getSentinel().getNodes());
                sentinelUsername = b.getSentinel().getUsername();
                sentinelPassword = b.getSentinel().getPassword();
            }
            config = new Config().setUsername(username).setPassword(password);
            SentinelServersConfig c2 = (SentinelServersConfig)config.useSentinelServers().setMasterName(sentinelMaster).addSentinelAddress(nodes).setSentinelPassword(sentinelPassword).setSentinelUsername(sentinelUsername).setDatabase(database).setClientName(clientName);
            if (connectTimeout != null) {
                c2.setConnectTimeout(connectTimeout.intValue());
            }
            if (connectTimeoutMethod != null && timeout != null) {
                c2.setTimeout(timeout.intValue());
            }
            this.initSSL(config);
        } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null || isCluster) {
            nodes = new String[]{};
            if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
                Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
                nodesMethod = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
                List nodesObject = (List)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)clusterObject);
                nodes = this.convert(prefix, nodesObject);
            }
            if (b != null && b.getCluster() != null) {
                nodes = this.convertNodes(prefix, b.getCluster().getNodes());
            }
            config = new Config().setUsername(username).setPassword(password);
            c = (ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setClientName(clientName);
            if (connectTimeout != null) {
                c.setConnectTimeout(connectTimeout.intValue());
            }
            if (connectTimeoutMethod != null && timeout != null) {
                c.setTimeout(timeout.intValue());
            }
            this.initSSL(config);
        } else {
            config = new Config().setUsername(username).setPassword(password);
            String singleAddr = prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort();
            if (b != null && b.getStandalone() != null) {
                database = b.getStandalone().getDatabase();
                singleAddr = prefix + b.getStandalone().getHost() + ":" + b.getStandalone().getPort();
            }
            c = (SingleServerConfig)config.useSingleServer().setAddress(singleAddr).setDatabase(database).setClientName(clientName);
            if (connectTimeout != null) {
                c.setConnectTimeout(connectTimeout.intValue());
            }
            if (connectTimeoutMethod != null && timeout != null) {
                c.setTimeout(timeout.intValue());
            }
            this.initSSL(config);
        }
        if (this.redissonAutoConfigurationCustomizers != null) {
            for (RedissonAutoConfigurationCustomizer customizer : this.redissonAutoConfigurationCustomizers) {
                customizer.customize(config);
            }
        }
        return Redisson.create((Config)config);
    }

    private void initSSL(Config config) {
        Method getSSLMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getSsl");
        if (getSSLMethod == null) {
            return;
        }
        DataRedisProperties.Ssl ssl = this.redisProperties.getSsl();
        if (ssl.getBundle() == null) {
            return;
        }
        ObjectProvider provider = this.ctx.getBeanProvider(SslBundles.class);
        SslBundles bundles = (SslBundles)provider.getIfAvailable();
        if (bundles == null) {
            return;
        }
        SslBundle b = bundles.getBundle(ssl.getBundle());
        if (b == null) {
            return;
        }
        config.setSslCiphers(b.getOptions().getCiphers());
        config.setSslProtocols(b.getOptions().getEnabledProtocols());
        config.setSslTrustManagerFactory(b.getManagers().getTrustManagerFactory());
        config.setSslKeyManagerFactory(b.getManagers().getKeyManagerFactory());
    }

    private String getPrefix() {
        Method isEnabledMethod;
        Boolean enabled;
        Object ss;
        String prefix = "redis://";
        Method isSSLMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"isSsl");
        Method getSSLMethod = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getSsl");
        if (isSSLMethod != null) {
            if (((Boolean)ReflectionUtils.invokeMethod((Method)isSSLMethod, (Object)this.redisProperties)).booleanValue()) {
                prefix = "rediss://";
            }
        } else if (getSSLMethod != null && (ss = ReflectionUtils.invokeMethod((Method)getSSLMethod, (Object)this.redisProperties)) != null && (enabled = (Boolean)ReflectionUtils.invokeMethod((Method)(isEnabledMethod = ReflectionUtils.findMethod(ss.getClass(), (String)"isEnabled")), (Object)ss)).booleanValue()) {
            prefix = "rediss://";
        }
        return prefix;
    }

    private String[] convertNodes(String prefix, List<Object> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (Object node : nodesObject) {
            Field hostField = ReflectionUtils.findField(node.getClass(), (String)"host");
            Field portField = ReflectionUtils.findField(node.getClass(), (String)"port");
            ReflectionUtils.makeAccessible((Field)hostField);
            ReflectionUtils.makeAccessible((Field)portField);
            String host = (String)ReflectionUtils.getField((Field)hostField, (Object)node);
            int port = (Integer)ReflectionUtils.getField((Field)portField, (Object)node);
            nodes.add(prefix + host + ":" + port);
        }
        return nodes.toArray(new String[0]);
    }

    private String[] convert(String prefix, List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!RedisURI.isValid((String)node)) {
                nodes.add(prefix + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = this.ctx.getResource(this.redissonProperties.getFile());
        return resource.getInputStream();
    }
}

