/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.redisson.EvictionScheduler;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonListMultimapValues;
import org.redisson.RedissonMultimapCache;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RListMultimapCache;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonListMultimapCache<K, V>
extends RedissonListMultimap<K, V>
implements RListMultimapCache<K, V> {
    private final RedissonMultimapCache<K> baseCache;

    RedissonListMultimapCache(RedissonClient client, EvictionScheduler evictionScheduler, CommandAsyncExecutor connectionManager, String name) {
        super(client, connectionManager, name);
        evictionScheduler.scheduleCleanMultimap(name, this.getTimeoutSetName());
        this.baseCache = new RedissonMultimapCache(connectionManager, name, this.codec, this.getTimeoutSetName());
    }

    RedissonListMultimapCache(RedissonClient client, EvictionScheduler evictionScheduler, Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(client, codec, connectionManager, name);
        evictionScheduler.scheduleCleanMultimap(name, this.getTimeoutSetName());
        this.baseCache = new RedissonMultimapCache(connectionManager, name, codec, this.getTimeoutSetName());
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String valuesName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('hget', KEYS[1], ARGV[2]); if value ~= false then local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate <= tonumber(ARGV[1]) then return 0;end; return redis.call('llen', ARGV[3]) > 0 and 1 or 0;end;return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), System.currentTimeMillis(), keyState, valuesName);
    }

    String getTimeoutSetName() {
        return "redisson_list_multimap_ttl{" + this.getName() + "}";
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        byte[] valueState = this.encodeMapValue(value);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], keys[i-1]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate > tonumber(ARGV[2]) then local name = '{' .. KEYS[1] .. '}:' .. v; local items = redis.call('lrange', name, 0, -1) for i=1,#items do if items[i] == ARGV[1] then return 1; end; end; end; end;end; return 0; ", Arrays.asList(this.getName(), this.getTimeoutSetName()), valueState, System.currentTimeMillis());
    }

    @Override
    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        byte[] valueState = this.encodeMapValue(value);
        String valuesName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate > tonumber(ARGV[1]) then local items = redis.call('lrange', KEYS[1], 0, -1); for i = 1, #items do if items[i] == ARGV[3] then return 1; end; end; end; return 0; ", Arrays.asList(valuesName, this.getTimeoutSetName()), System.currentTimeMillis(), keyState, valueState);
    }

    @Override
    public RList<V> get(K key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String valuesName = this.getValuesName(keyHash);
        return new RedissonListMultimapValues(this.codec, this.commandExecutor, valuesName, this.getTimeoutSetName(), key);
    }

    @Override
    public RFuture<Collection<V>> getAllAsync(K key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String valuesName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "local expireDate = 92233720368547758; local expireDateScore = redis.call('zscore', KEYS[2], ARGV[2]); if expireDateScore ~= false then expireDate = tonumber(expireDateScore) end; if expireDate > tonumber(ARGV[1]) then return redis.call('lrange', KEYS[1], 0, -1); end; return {}; ", Arrays.asList(valuesName, this.getTimeoutSetName()), System.currentTimeMillis(), keyState);
    }

    @Override
    public RFuture<Collection<V>> removeAllAsync(Object key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String valuesName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); redis.call('zrem', KEYS[3], ARGV[1]); return members; ", Arrays.asList(this.getName(), valuesName, this.getTimeoutSetName()), new Object[]{keyState});
    }

    @Override
    public boolean expireKey(K key, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.expireKeyAsync(key, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireKeyAsync(K key, long timeToLive, TimeUnit timeUnit) {
        return this.baseCache.expireKeyAsync(key, timeToLive, timeUnit);
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.baseCache.deleteAsync();
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.baseCache.expireAsync(timeToLive, timeUnit);
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.baseCache.expireAtAsync(timestamp);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.baseCache.clearExpireAsync();
    }
}

