/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimapIterator;
import org.redisson.RedissonMultiMapIterator;
import org.redisson.RedissonMultimap;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonListMultimap<K, V>
extends RedissonMultimap<K, V>
implements RListMultimap<K, V> {
    private static final RedisStrictCommand<Boolean> LLEN_VALUE = new RedisStrictCommand<Boolean>("LLEN", new BooleanAmountReplayConvertor());

    RedissonListMultimap(RedissonClient client, CommandAsyncExecutor connectionManager, String name) {
        super(client, connectionManager, name);
    }

    RedissonListMultimap(RedissonClient client, Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(client, codec, connectionManager, name);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = '{' .. KEYS[1] .. '}:' .. v; size = size + redis.call('llen', name); end;end; return size; ", Arrays.asList(this.getName()), new Object[0]);
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getName(), this.codec, LLEN_VALUE, setName);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        byte[] valueState = this.encodeMapValue(value);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local name = '{' .. KEYS[1] .. '}:' .. v; local items = redis.call('lrange', name, 0, -1) for i=1,#items do if items[i] == ARGV[1] then return 1; end; end; end;end; return 0; ", Arrays.asList(this.getName()), new Object[]{valueState});
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.get(this.containsEntryAsync(key, value));
    }

    @Override
    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        byte[] valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local items = redis.call('lrange', KEYS[1], 0, -1) for i=1,#items do if items[i] == ARGV[1] then return 1; end; end; return 0; ", Collections.singletonList(setName), new Object[]{valueState});
    }

    @Override
    public boolean put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    @Override
    public RFuture<Boolean> putAsync(K key, V value) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        byte[] valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); redis.call('rpush', KEYS[2], ARGV[3]); return 1; ", Arrays.asList(this.getName(), setName), keyState, keyHash, valueState);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        byte[] valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local res = redis.call('lrem', KEYS[2], 1, ARGV[2]); if res == 1 and redis.call('llen', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end; return res; ", Arrays.asList(this.getName(), setName), keyState, valueState);
    }

    @Override
    public RFuture<Boolean> putAllAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        byte[] keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            byte[] valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return redis.call('rpush', KEYS[2], unpack(ARGV, 3, #ARGV)); ", Arrays.asList(this.getName(), setName), params.toArray());
    }

    @Override
    public RList<V> get(K key) {
        final byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        final String setName = this.getValuesName(keyHash);
        return new RedissonList<V>(this.codec, this.commandExecutor, setName){

            @Override
            public RFuture<Boolean> deleteAsync() {
                return RedissonListMultimap.this.fastRemoveAsync(Arrays.asList(new Object[]{keyState}), Arrays.asList(setName), RedisCommands.EVAL_BOOLEAN_AMOUNT);
            }

            @Override
            public RFuture<Boolean> clearExpireAsync() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> expireAtAsync(long timestamp) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Long> remainTimeToLiveAsync() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Void> renameAsync(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> renamenxAsync(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }
        };
    }

    @Override
    public List<V> getAll(K key) {
        return (List)this.get(this.getAllAsync(key));
    }

    @Override
    public RFuture<Collection<V>> getAllAsync(K key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.LRANGE, setName, 0, -1);
    }

    @Override
    public List<V> removeAll(Object key) {
        return (List)this.get(this.removeAllAsync(key));
    }

    @Override
    public RFuture<Collection<V>> removeAllAsync(Object key) {
        byte[] keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getName(), setName), new Object[]{keyState});
    }

    @Override
    public List<V> replaceValues(K key, Iterable<? extends V> values) {
        return (List)this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    public RFuture<Collection<V>> replaceValuesAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        byte[] keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            byte[] valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LIST, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); redis.call('rpush', KEYS[2], unpack(ARGV, 3, #ARGV)); return members; ", Arrays.asList(this.getName(), setName), params.toArray());
    }

    @Override
    Iterator<V> valuesIterator() {
        return new RedissonListMultimapIterator<K, V, V>(this, this.commandExecutor, this.codec){

            @Override
            V getValue(V entry) {
                return entry;
            }
        };
    }

    @Override
    RedissonMultiMapIterator<K, V, Map.Entry<K, V>> entryIterator() {
        return new RedissonListMultimapIterator(this, this.commandExecutor, this.codec);
    }
}

