/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.decoder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class MapGetAllDecoder
implements MultiDecoder<Map<Object, Object>> {
    private final int shiftIndex;
    private final List<Object> args;
    private final boolean allowNulls;

    public MapGetAllDecoder(List<Object> args, int shiftIndex) {
        this(args, shiftIndex, false);
    }

    public MapGetAllDecoder(List<Object> args, int shiftIndex, boolean allowNulls) {
        this.args = args;
        this.shiftIndex = shiftIndex;
        this.allowNulls = allowNulls;
    }

    @Override
    public Object decode(ByteBuf buf, State state) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isApplicable(int paramNum, State state) {
        return false;
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        if (parts.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(parts.size());
        for (int index = 0; index < this.args.size() - this.shiftIndex; ++index) {
            Object value = parts.get(index);
            if (!this.allowNulls && value == null) continue;
            result.put(this.args.get(index + this.shiftIndex), value);
        }
        return result;
    }
}

