/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.openhft.hashing.LongHashFunction;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RFuture;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.command.CommandBatchService;
import org.redisson.command.CommandExecutor;

public class RedissonBloomFilter<T>
extends RedissonExpirable
implements RBloomFilter<T> {
    private static final long MAX_SIZE = 0xFFFFFFFEL;
    private volatile long size;
    private volatile int hashIterations;
    private final CommandExecutor commandExecutor;

    protected RedissonBloomFilter(CommandExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
    }

    protected RedissonBloomFilter(Codec codec, CommandExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.commandExecutor = commandExecutor;
    }

    private int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    private long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    @Override
    public boolean add(T object) {
        byte[] state = this.encode(object);
        while (true) {
            if (this.size == 0L) {
                this.readConfig();
            }
            int hashIterations = this.hashIterations;
            long size = this.size;
            long[] indexes = this.hash(state, hashIterations, size);
            CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
            this.addConfigCheck(hashIterations, size, executorService);
            for (int i = 0; i < indexes.length; ++i) {
                executorService.writeAsync(this.getName(), this.codec, RedisCommands.SETBIT, this.getName(), indexes[i], 1);
            }
            try {
                List<?> result = executorService.execute();
                for (Boolean val : result.subList(1, result.size() - 1)) {
                    if (!val.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            catch (RedisException e) {
                if (e.getMessage().contains("Bloom filter config has been changed")) continue;
                throw e;
            }
            break;
        }
    }

    private long[] hash(byte[] state, int iterations, long size) {
        long hash1 = LongHashFunction.xx_r39().hashBytes(state);
        long hash2 = LongHashFunction.farmUo().hashBytes(state);
        long[] indexes = new long[iterations];
        long hash = hash1;
        for (int i = 0; i < iterations; ++i) {
            indexes[i] = (hash & Long.MAX_VALUE) % size;
            if (i % 2 == 0) {
                hash += hash2;
                continue;
            }
            hash += hash1;
        }
        return indexes;
    }

    @Override
    public boolean contains(T object) {
        byte[] state = this.encode(object);
        while (true) {
            if (this.size == 0L) {
                this.readConfig();
            }
            int hashIterations = this.hashIterations;
            long size = this.size;
            long[] indexes = this.hash(state, hashIterations, size);
            CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
            this.addConfigCheck(hashIterations, size, executorService);
            for (int i = 0; i < indexes.length; ++i) {
                executorService.readAsync(this.getName(), this.codec, RedisCommands.GETBIT, this.getName(), indexes[i]);
            }
            try {
                List<?> result = executorService.execute();
                for (Boolean val : result.subList(1, result.size() - 1)) {
                    if (val.booleanValue()) continue;
                    return false;
                }
                return true;
            }
            catch (RedisException e) {
                if (e.getMessage().contains("Bloom filter config has been changed")) continue;
                throw e;
            }
            break;
        }
    }

    private void addConfigCheck(int hashIterations, long size, CommandBatchService executorService) {
        executorService.evalReadAsync(this.getConfigName(), this.codec, RedisCommands.EVAL_VOID, "local size = redis.call('hget', KEYS[1], 'size');local hashIterations = redis.call('hget', KEYS[1], 'hashIterations');assert(size == ARGV[1] and hashIterations == ARGV[2], 'Bloom filter config has been changed')", Arrays.asList(this.getConfigName()), size, hashIterations);
    }

    @Override
    public int count() {
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
        RFuture configFuture = executorService.readAsync(this.getConfigName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Map<Object, Object>>("HGETALL", new ObjectMapReplayDecoder()), this.getConfigName());
        RFuture cardinalityFuture = executorService.readAsync(this.getName(), this.codec, RedisCommands.BITCOUNT, this.getName());
        executorService.execute();
        this.readConfig((Map)configFuture.getNow());
        return (int)((double)(-this.size) / (double)this.hashIterations * Math.log(1.0 - (double)((Long)cardinalityFuture.getNow()).longValue() / (double)this.size));
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_OBJECTS, this.getName(), this.getConfigName());
    }

    private void readConfig() {
        RFuture future = this.commandExecutor.readAsync(this.getConfigName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Map<Object, Object>>("HGETALL", new ObjectMapReplayDecoder()), this.getConfigName());
        Map config = (Map)this.commandExecutor.get(future);
        this.readConfig(config);
    }

    private void readConfig(Map<String, String> config) {
        if (config.get("hashIterations") == null || config.get("size") == null) {
            throw new IllegalStateException("Bloom filter is not initialized!");
        }
        this.size = Long.valueOf(config.get("size"));
        this.hashIterations = Integer.valueOf(config.get("hashIterations"));
    }

    @Override
    public boolean tryInit(long expectedInsertions, double falseProbability) {
        this.size = this.optimalNumOfBits(expectedInsertions, falseProbability);
        if (this.size > 0xFFFFFFFEL) {
            throw new IllegalArgumentException("Bloom filter can't be greater than 4294967294. But calculated size is " + this.size);
        }
        this.hashIterations = this.optimalNumOfHashFunctions(expectedInsertions, this.size);
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
        executorService.evalReadAsync(this.getConfigName(), this.codec, RedisCommands.EVAL_VOID, "local size = redis.call('hget', KEYS[1], 'size');local hashIterations = redis.call('hget', KEYS[1], 'hashIterations');assert(size == false and hashIterations == false, 'Bloom filter config has been changed')", Arrays.asList(this.getConfigName()), this.size, this.hashIterations);
        executorService.writeAsync(this.getConfigName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Void>("HMSET", new VoidReplayConvertor()), this.getConfigName(), "size", this.size, "hashIterations", this.hashIterations, "expectedInsertions", expectedInsertions, "falseProbability", BigDecimal.valueOf(falseProbability).toPlainString());
        try {
            executorService.execute();
        }
        catch (RedisException e) {
            if (!e.getMessage().contains("Bloom filter config has been changed")) {
                throw e;
            }
            this.readConfig();
            return false;
        }
        return true;
    }

    private String getConfigName() {
        return "{" + this.getName() + "}__config";
    }

    @Override
    public long getExpectedInsertions() {
        Long result = (Long)this.commandExecutor.read(this.getConfigName(), LongCodec.INSTANCE, RedisCommands.HGET, this.getConfigName(), "expectedInsertions");
        return this.check(result);
    }

    @Override
    public double getFalseProbability() {
        Double result = (Double)this.commandExecutor.read(this.getConfigName(), DoubleCodec.INSTANCE, RedisCommands.HGET, this.getConfigName(), "falseProbability");
        return this.check(result);
    }

    @Override
    public long getSize() {
        Long result = (Long)this.commandExecutor.read(this.getConfigName(), LongCodec.INSTANCE, RedisCommands.HGET, this.getConfigName(), "size");
        return this.check(result);
    }

    @Override
    public int getHashIterations() {
        Integer result = (Integer)this.commandExecutor.read(this.getConfigName(), IntegerCodec.INSTANCE, RedisCommands.HGET, this.getConfigName(), "hashIterations");
        return this.check(result);
    }

    private <V> V check(V result) {
        if (result == null) {
            throw new IllegalStateException("Bloom filter is not initialized!");
        }
        return result;
    }
}

