/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Array;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import java.util.function.Function;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.JsSuccess;

public interface Reader<T> {
    public JsResult<T> read(JsValue var1);

    default public <B> Reader<B> map(Function<T, B> f) {
        Reader self = this;
        return value -> self.read(value).map(f);
    }

    default public <B> Reader<B> flatMap(Function<T, Reader<B>> f) {
        Reader self = this;
        return value -> self.read(value).flatMap((T t) -> ((Reader)f.apply(t)).read(value));
    }

    default public Reader<T> filter(Function<T, Boolean> f) {
        Reader self = this;
        return value -> self.read(value).filter(f);
    }

    default public Reader<T> filterNot(Function<T, Boolean> f) {
        Reader self = this;
        return value -> self.read(value).filterNot(f);
    }

    default public Reader<T> orElse(Reader<T> v) {
        Reader self = this;
        return value -> self.read(value).getOrElse(v.read(value));
    }

    default public <B extends JsValue> Reader<T> compose(Reader<B> v) {
        Reader self = this;
        return value -> {
            JsResult res = v.read(value);
            Iterator iterator = res.asError().iterator();
            if (iterator.hasNext()) {
                JsError t = (JsError)iterator.next();
                return new JsError(t.errors);
            }
            iterator = res.asSuccess().iterator();
            if (iterator.hasNext()) {
                JsSuccess t = (JsSuccess)iterator.next();
                return self.read((JsValue)t.get());
            }
            throw new IllegalStateException("Should not happen");
        };
    }

    default public Reader<T> and(Reader<T> v) {
        Reader self = this;
        return value -> {
            JsResult res1 = self.read(value);
            JsResult res2 = v.read(value);
            if (res1.isSuccess() && res2.isSuccess()) {
                return res1;
            }
            Array errors = Array.empty();
            if (res1.isErrors()) {
                errors = errors.appendAll(((JsError)res1.asError().get()).errors);
            }
            if (res2.isErrors()) {
                errors = errors.appendAll(((JsError)res2.asError().get()).errors);
            }
            return new JsError((Seq<Throwable>)errors);
        };
    }
}

