/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.Iterator;
import java.util.function.Function;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;

public class JsSuccess<T>
extends JsResult<T> {
    private final T value;

    public JsSuccess(T value) {
        this.value = value;
    }

    @Override
    public Option<JsError<T>> asError() {
        return Option.none();
    }

    @Override
    public Option<JsSuccess<T>> asSuccess() {
        return Option.some((Object)this);
    }

    @Override
    public boolean hasErrors() {
        return false;
    }

    @Override
    public T getValueOrNull() {
        return this.value;
    }

    @Override
    public boolean isErrors() {
        return false;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public int countErrors() {
        return 0;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public T orError(Throwable t) {
        return this.get();
    }

    @Override
    public Option<T> getOpt() {
        return Option.some(this.value);
    }

    @Override
    public T getValueOrElse(T result) {
        return this.value;
    }

    @Override
    public T getValueOrElse(Throwable result) {
        return this.value;
    }

    @Override
    public JsResult<T> getOrElse(JsResult<T> result) {
        return new JsSuccess<T>(this.value);
    }

    @Override
    public <B> JsResult<B> map(Function<T, B> map) {
        return new JsSuccess<B>(map.apply(this.value));
    }

    @Override
    public <B> JsResult<B> flatMap(Function<T, JsResult<B>> map) {
        return map.apply(this.value);
    }

    @Override
    public JsResult<T> filter(Function<T, Boolean> p) {
        return this.flatMap(a -> {
            if (((Boolean)p.apply(a)).booleanValue()) {
                return new JsSuccess<Object>(a);
            }
            return new JsError((Seq<Throwable>)Array.empty());
        });
    }

    @Override
    public JsResult<T> filterNot(Function<T, Boolean> p) {
        return this.flatMap(a -> {
            if (((Boolean)p.apply(a)).booleanValue()) {
                return new JsError((Seq<Throwable>)Array.empty());
            }
            return new JsSuccess<Object>(a);
        });
    }

    @Override
    public JsResult<T> filter(Function<T, Boolean> predicate, Seq<Throwable> errors) {
        return this.flatMap(a -> {
            if (((Boolean)predicate.apply(a)).booleanValue()) {
                return new JsSuccess<Object>(a);
            }
            return new JsError(errors);
        });
    }

    @Override
    public JsResult<T> filterNot(Function<T, Boolean> predicate, Seq<Throwable> errors) {
        return this.flatMap(a -> {
            if (((Boolean)predicate.apply(a)).booleanValue()) {
                return new JsError(errors);
            }
            return new JsSuccess<Object>(a);
        });
    }

    @Override
    public JsResult<T> filter(Function<T, Boolean> predicate, Throwable error) {
        return this.flatMap(a -> {
            if (((Boolean)predicate.apply(a)).booleanValue()) {
                return new JsSuccess<Object>(a);
            }
            return new JsError((Seq<Throwable>)Array.of((Object)error));
        });
    }

    @Override
    public JsResult<T> filterNot(Function<T, Boolean> predicate, Throwable error) {
        return this.flatMap(a -> {
            if (((Boolean)predicate.apply(a)).booleanValue()) {
                return new JsError((Seq<Throwable>)Array.of((Object)error));
            }
            return new JsSuccess<Object>(a);
        });
    }

    @Override
    public Iterator<T> iterator() {
        return Array.of(this.value).iterator();
    }

    public String toString() {
        return "JsSuccess(" + this.value + ')';
    }
}

