/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.Iterator;
import java.util.function.Function;
import org.reactivecouchbase.json.JsArray;
import org.reactivecouchbase.json.Json;
import org.reactivecouchbase.json.Throwables;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.JsSuccess;

public class JsError<T>
extends JsResult<T> {
    public final Seq<Throwable> errors;

    @Override
    public T getValueOrElse(T result) {
        return result;
    }

    @Override
    public T getValueOrNull() {
        return null;
    }

    @Override
    public T getValueOrElse(Throwable result) {
        throw Throwables.propagate(result);
    }

    @Override
    public Option<JsError<T>> asError() {
        return Option.some((Object)this);
    }

    @Override
    public Option<JsSuccess<T>> asSuccess() {
        return Option.none();
    }

    @Override
    public boolean hasErrors() {
        return true;
    }

    @Override
    public boolean isErrors() {
        return true;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public int countErrors() {
        return this.errors.size();
    }

    @Override
    public T orError(Throwable t) {
        throw Throwables.propagate(t);
    }

    @Override
    public T get() {
        throw new IllegalStateException("No value");
    }

    @Override
    public Option<T> getOpt() {
        return Option.none();
    }

    @Override
    public JsResult<T> getOrElse(JsResult<T> result) {
        return result;
    }

    @Override
    public <B> JsResult<B> map(Function<T, B> map) {
        return new JsError<T>(this.errors);
    }

    @Override
    public <B> JsResult<B> flatMap(Function<T, JsResult<B>> map) {
        return new JsError<T>(this.errors);
    }

    @Override
    public JsResult<T> filter(Function<T, Boolean> predicate) {
        return new JsError<T>(this.errors);
    }

    @Override
    public JsResult<T> filterNot(Function<T, Boolean> predicate) {
        return new JsError<T>(this.errors);
    }

    @Override
    public JsResult<T> filter(Function<T, Boolean> predicate, Seq<Throwable> errs) {
        JsError val = this;
        if (((JsResult)val).isSuccess() && predicate.apply(((JsResult)val).get()).booleanValue()) {
            return new JsError<T>((Seq<Throwable>)this.errors.appendAll(errs));
        }
        return new JsError<T>(this.errors);
    }

    @Override
    public JsResult<T> filterNot(Function<T, Boolean> predicate, Seq<Throwable> errs) {
        JsError val = this;
        if (((JsResult)val).isSuccess() && !predicate.apply(((JsResult)val).get()).booleanValue()) {
            return new JsError<T>((Seq<Throwable>)this.errors.appendAll(errs));
        }
        return new JsError<T>(this.errors);
    }

    @Override
    public JsResult<T> filter(Function<T, Boolean> predicate, Throwable error) {
        JsError val = this;
        if (((JsResult)val).isSuccess() && predicate.apply(((JsResult)val).get()).booleanValue()) {
            return new JsError<T>((Seq<Throwable>)this.errors.append((Object)error));
        }
        return new JsError<T>(this.errors);
    }

    @Override
    public JsResult<T> filterNot(Function<T, Boolean> predicate, Throwable error) {
        JsError val = this;
        if (((JsResult)val).isSuccess() && !predicate.apply(((JsResult)val).get()).booleanValue()) {
            return new JsError<T>((Seq<Throwable>)this.errors.append((Object)error));
        }
        return new JsError<T>(this.errors);
    }

    public JsError(Seq<Throwable> errors) {
        this.errors = errors;
    }

    public JsError(Throwable errors) {
        this.errors = Array.of((Object)errors);
    }

    public Throwable firstError() {
        if (this.errors.isEmpty()) {
            return new IllegalAccessError("No error, that's weird !!!");
        }
        return (Throwable)this.errors.iterator().next();
    }

    @Override
    public Iterator<T> iterator() {
        return Array.empty().iterator();
    }

    public JsArray errors() {
        return Json.arr(this.errorsAsString());
    }

    public Seq<String> errorsAsString() {
        return this.errors.map(Throwable::getMessage);
    }

    public String toString() {
        return "JsError(" + this.errors + ')';
    }
}

