/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.vavr.collection.Array;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Validation;
import java.util.function.Function;
import org.reactivecouchbase.json.Jackson;
import org.reactivecouchbase.json.JsArray;
import org.reactivecouchbase.json.JsObject;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.mapping.DefaultReaders;
import org.reactivecouchbase.json.mapping.Format;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.JsSuccess;
import org.reactivecouchbase.json.mapping.Reader;
import org.reactivecouchbase.json.mapping.Writer;

public class Json {
    public static JsObject obj(Map<String, ?> objects) {
        return new JsObject((Map<String, JsValue>)objects.bimap(k -> k, Json::wrap));
    }

    public static <T> Format<T> format(Class<T> clazz) {
        final Writer<T> writer = Json.writes(clazz);
        final Reader<T> reader = Json.reads(clazz);
        return new Format<T>(){

            @Override
            public JsResult<T> read(JsValue value) {
                return reader.read(value);
            }

            @Override
            public JsValue write(T value) {
                return writer.write(value);
            }
        };
    }

    public static <T> Reader<T> reads(Class<T> clazz) {
        if (DefaultReaders.readers.containsKey(clazz)) {
            return (Reader)DefaultReaders.readers.get(clazz).get();
        }
        return value -> {
            try {
                return new JsSuccess(Jackson.fromJson(Jackson.jsValueToJsonNode(value), clazz));
            }
            catch (Exception e) {
                return new JsError((Seq<Throwable>)Array.of((Object)e));
            }
        };
    }

    public static <T> Writer<T> writes(Class<T> clazz) {
        return value -> Jackson.jsonNodeToJsValue(Jackson.toJson(value));
    }

    public static JsValue toJson(Object o) {
        return Jackson.jsonNodeToJsValue(Jackson.toJson(o));
    }

    public static JsValue parse(String json) {
        return Jackson.parseJsValue(json);
    }

    public static <T> Reader<T> safeReader(Reader<T> reader) {
        return value -> {
            try {
                return reader.read(value);
            }
            catch (Exception e) {
                return JsResult.error(e);
            }
        };
    }

    public static JsObject obj(Iterable<? extends JsObject> objects) {
        JsObject root = new JsObject();
        for (JsObject jsObject : objects) {
            root = root.add(jsObject);
        }
        return root;
    }

    public static JsObject obj(JsObject ... objects) {
        return Json.obj((Iterable<? extends JsObject>)Array.of((Object[])objects));
    }

    public static JsObject obj() {
        return new JsObject();
    }

    public static <T> JsArray array(Seq<T> objects) {
        return new JsArray((Seq<JsValue>)objects.map(Json::wrap));
    }

    public static JsArray arr(Object ... objects) {
        if (objects != null && objects.length == 1 && Seq.class.isAssignableFrom(objects[0].getClass())) {
            return Json.array((Seq)objects[0]);
        }
        return Json.array(Array.of((Object[])objects));
    }

    public static <T> JsArray arr(Seq<T> collection, Writer<T> writer) {
        Object[] objectArray = new Object[1];
        objectArray[0] = collection.map(writer::write);
        return Json.arr(objectArray);
    }

    public static String stringify(JsValue value) {
        return value.toJsonString();
    }

    public static String stringify(JsValue value, boolean pretty) {
        if (pretty) {
            return Json.prettyPrint(value);
        }
        return Json.stringify(value);
    }

    public static JsValue wrap(Object o) {
        return Jackson.jsonNodeToJsValue(Jackson.toJson(o));
    }

    public static <T> JsResult<T> fromJson(JsValue value, Reader<T> reader) {
        return reader.read(value);
    }

    public static <T> JsResult<T> fromJson(String value, Reader<T> reader) {
        return reader.read(Json.parse(value));
    }

    public static <E, T> Validation<E, T> fromJson(JsValue value, Function<JsValue, Validation<E, T>> reader) {
        return reader.apply(value);
    }

    public static <E, T> Validation<E, T> fromJson(String value, Function<JsValue, Validation<E, T>> reader) {
        return Json.fromJson(Json.parse(value), reader);
    }

    public static <T, V extends T> JsValue toJson(V o, Writer<T> writer) {
        return writer.write(o);
    }

    public static <T> JsonNode toJackson(JsValue value) {
        return Jackson.toJson(value);
    }

    public static String prettyPrint(JsValue value) {
        return Jackson.prettify(value);
    }

    public static JsValue fromJsonNode(JsonNode node) {
        return Jackson.jsonNodeToJsValue(node);
    }
}

