/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json;

import com.fasterxml.jackson.databind.node.TextNode;
import io.vavr.control.Option;
import org.reactivecouchbase.json.JsUndefined;
import org.reactivecouchbase.json.JsValue;

public class JsString
extends JsValue
implements Comparable<JsString> {
    public final String value;

    public static JsString apply(String value) {
        return new JsString(value);
    }

    public JsString(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
    }

    @Override
    public JsValue querySelector(String query) {
        return JsUndefined.JSUNDEFINED_INSTANCE;
    }

    @Override
    public Option<JsValue> querySelectorOpt(String query) {
        return Option.none();
    }

    @Override
    public int compareTo(JsString jsString) {
        return this.value.compareTo(jsString.value);
    }

    @Override
    String toJsonString() {
        return new TextNode(this.value).toString();
    }

    public String toString() {
        return "JsString(" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsString)) {
            return false;
        }
        JsString jsString = (JsString)o;
        return this.value.equals(jsString.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean deepEquals(Object o) {
        return this.equals(o);
    }

    @Override
    public JsString cloneNode() {
        return new JsString(this.value);
    }
}

