/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.utils.Inflector;
import org.raml.parser.visitor.NodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class TemplateResolver {
    public static final String OPTIONAL_MODIFIER = "?";
    public static final String ALL_ACTIONS = "*";
    public static final String TRAIT_USE_KEY = "is";
    public static final String RESOURCE_TYPE_USE_KEY = "type";
    public static final Pattern TEMPLATE_PARAMETER_PATTERN = Pattern.compile("<<[^>]+>>");
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IncludeResolver includeResolver = new IncludeResolver();
    private Map<String, MappingNode> resourceTypesMap = new HashMap<String, MappingNode>();
    private Map<String, MappingNode> traitsMap = new HashMap<String, MappingNode>();
    private ResourceLoader resourceLoader;
    private NodeHandler nodeNandler;
    private Set<MappingNode> resolvedNodes = new HashSet<MappingNode>();

    public TemplateResolver(ResourceLoader resourceLoader, NodeHandler nodeNandler) {
        this.resourceLoader = resourceLoader;
        this.nodeNandler = nodeNandler;
        this.includeResolver.setContextPath(((ContextPathAware)((Object)nodeNandler)).getContextPath());
    }

    public Map<String, MappingNode> getResourceTypesMap() {
        return this.resourceTypesMap;
    }

    public Map<String, MappingNode> getTraitsMap() {
        return this.traitsMap;
    }

    public List<ValidationResult> init(MappingNode rootNode) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (rootNode == null) {
            validationResults.add(ValidationResult.createErrorResult("Invalid Root Node"));
            return validationResults;
        }
        for (int i = 0; i < rootNode.getValue().size(); ++i) {
            String key;
            NodeTuple rootTuple = (NodeTuple)rootNode.getValue().get(i);
            Node keyNode = rootTuple.getKeyNode();
            if (keyNode.getNodeId() != NodeId.scalar || !(key = ((ScalarNode)keyNode).getValue()).equals("resourceTypes") && !key.equals("traits")) continue;
            Node templateSequence = this.resolveInclude(rootTuple.getValueNode());
            if (templateSequence != rootTuple.getValueNode()) {
                rootNode.getValue().remove(i);
                rootNode.getValue().add(i, new NodeTuple(keyNode, templateSequence));
            }
            if (templateSequence.getNodeId() != NodeId.sequence) {
                validationResults.add(ValidationResult.createErrorResult("Sequence expected", templateSequence));
                rootNode.getValue().remove(i);
                rootNode.getValue().add(i, new NodeTuple(keyNode, (Node)new SequenceNode(Tag.SEQ, new ArrayList(), DumperOptions.FlowStyle.BLOCK)));
                break;
            }
            this.loopTemplateSequence((SequenceNode)templateSequence, key, validationResults);
        }
        return validationResults;
    }

    private void loopTemplateSequence(SequenceNode templateSequence, String templateType, List<ValidationResult> validationResults) {
        ArrayList<Node> prunedTemplates = new ArrayList<Node>();
        for (int j = 0; j < templateSequence.getValue().size(); ++j) {
            Node template = this.resolveInclude((Node)templateSequence.getValue().get(j));
            if (template.getNodeId() != NodeId.mapping) {
                validationResults.add(ValidationResult.createErrorResult("Mapping expected", templateSequence.getStartMark(), templateSequence.getEndMark()));
                break;
            }
            for (NodeTuple tuple : ((MappingNode)template).getValue()) {
                if (tuple.getKeyNode().getNodeId() != NodeId.scalar) {
                    validationResults.add(ValidationResult.createErrorResult("Only scalar keys are allowed", tuple.getKeyNode()));
                    continue;
                }
                String templateKey = ((ScalarNode)tuple.getKeyNode()).getValue();
                Node templateValue = this.resolveInclude(tuple.getValueNode());
                if (templateValue.getNodeId() != NodeId.mapping) {
                    validationResults.add(ValidationResult.createErrorResult("Mapping expected", templateValue.getStartMark(), templateValue.getEndMark()));
                    continue;
                }
                if (templateType.equals("resourceTypes")) {
                    this.resourceTypesMap.put(templateKey, (MappingNode)templateValue);
                }
                if (templateType.equals("traits")) {
                    this.traitsMap.put(templateKey, (MappingNode)templateValue);
                }
                prunedTemplates.add(this.getFakeTemplateNode(tuple.getKeyNode()));
                this.updateIncludeTag(templateValue, templateSequence.getTag());
            }
        }
        templateSequence.getValue().clear();
        templateSequence.getValue().addAll(prunedTemplates);
    }

    private void updateIncludeTag(Node templateValue, Tag parentTag) {
        if (parentTag.startsWith("!include-applied_")) {
            Tag currentTag = templateValue.getTag();
            if (currentTag.startsWith("!include-applied_")) {
                String parentTagValue = parentTag.getValue();
                String currentTagValue = currentTag.getValue();
                templateValue.setTag(new Tag("!include-compound_" + parentTagValue.length() + "_" + parentTagValue + "_" + currentTagValue.length() + "_" + currentTagValue));
            } else {
                templateValue.setTag(parentTag);
            }
        }
    }

    private Node resolveInclude(Node node) {
        return this.resolveInclude(node, null);
    }

    private Node resolveInclude(Node node, Tag tag) {
        if (node.getNodeId() == NodeId.scalar && node.getTag().equals((Object)IncludeResolver.INCLUDE_TAG)) {
            if (tag != null && tag.startsWith("!include-applied_")) {
                ScalarNode scalarNode = (ScalarNode)node;
                String parentPath = this.includeResolver.getContextPath().resolveRelativePath(tag);
                String includePathRecalculated = ContextPath.getParentPath(parentPath) + scalarNode.getValue();
                node = new ScalarNode(scalarNode.getTag(), includePathRecalculated, node.getStartMark(), node.getEndMark(), scalarNode.getScalarStyle());
            }
            return this.includeResolver.resolve(node, this.resourceLoader, this.nodeNandler);
        }
        return node;
    }

    private Node getFakeTemplateNode(Node keyNode) {
        ArrayList<NodeTuple> innerTuples = new ArrayList<NodeTuple>();
        innerTuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, "displayName", null, null, DumperOptions.ScalarStyle.PLAIN), keyNode));
        MappingNode innerNode = new MappingNode(Tag.MAP, innerTuples, DumperOptions.FlowStyle.BLOCK);
        ArrayList<NodeTuple> outerTuples = new ArrayList<NodeTuple>();
        outerTuples.add(new NodeTuple(keyNode, (Node)innerNode));
        return new MappingNode(Tag.MAP, outerTuples, DumperOptions.FlowStyle.BLOCK);
    }

    public List<ValidationResult> resolve(MappingNode resourceNode, String relativeUri, String fullUri) {
        ArrayList<ValidationResult> templateValidations = new ArrayList<ValidationResult>();
        if (this.resolvedNodes.contains(resourceNode)) {
            return templateValidations;
        }
        this.resolvedNodes.add(resourceNode);
        return new ResourceTemplateMerger(templateValidations, resourceNode, relativeUri, fullUri).merge();
    }

    private static boolean isAction(String key) {
        try {
            ActionType.valueOf(TemplateResolver.normalizeKey(key).toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static String normalizeKey(String key) {
        if (key.endsWith(OPTIONAL_MODIFIER)) {
            return key.substring(0, key.length() - 1);
        }
        return key;
    }

    private class ResourceTemplateMerger {
        private List<ValidationResult> templateValidations;
        private MappingNode resourceNode;
        private String relativeUri;
        private String fullUri;
        private String currentAction;

        public ResourceTemplateMerger(List<ValidationResult> templateValidations, MappingNode resourceNode, String relativeUri, String fullUri) {
            this.templateValidations = templateValidations;
            this.resourceNode = resourceNode;
            this.relativeUri = relativeUri;
            this.fullUri = fullUri;
        }

        public List<ValidationResult> merge() {
            if (this.mergeTemplatesIfNeeded(this.resourceNode, new HashMap<String, Node>())) {
                this.removeOptionalNodes(this.resourceNode, true);
            }
            return this.templateValidations;
        }

        private boolean mergeTemplatesIfNeeded(MappingNode resourceNode, Map<String, Node> globalActionNodes) {
            TemplateReferences references = this.extractTemplateReferences(resourceNode, globalActionNodes);
            Node typeReference = references.typeReference;
            Map traitsReference = references.traitsReference;
            Map actionNodes = references.actionNodes;
            if (!traitsReference.isEmpty()) {
                for (Map.Entry actionEntry : traitsReference.entrySet()) {
                    String actionName = (String)actionEntry.getKey();
                    if (actionName.equals(TemplateResolver.ALL_ACTIONS)) continue;
                    this.applyTraitsToActions((SequenceNode)actionEntry.getValue(), actionNodes, actionName);
                }
                if (traitsReference.get(TemplateResolver.ALL_ACTIONS) != null && typeReference == null) {
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(TemplateResolver.ALL_ACTIONS), actionNodes, null);
                }
            }
            if (typeReference != null) {
                MappingNode clone = this.cloneTemplate(typeReference, TemplateType.RESOURCE_TYPE);
                if (clone == null) {
                    return false;
                }
                for (Map.Entry entry : actionNodes.entrySet()) {
                    if (globalActionNodes.containsKey(entry.getKey())) continue;
                    globalActionNodes.put((String)entry.getKey(), (Node)entry.getValue());
                }
                this.mergeTemplatesIfNeeded(clone, actionNodes);
                if (traitsReference.get(TemplateResolver.ALL_ACTIONS) != null) {
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(TemplateResolver.ALL_ACTIONS), actionNodes, null);
                }
                this.mergeNodes((Node)resourceNode, (Node)clone, new MergeContext(Resource.class, clone.getTag()));
            }
            return !traitsReference.isEmpty() || typeReference != null;
        }

        private TemplateReferences extractTemplateReferences(MappingNode resourceNode, Map<String, Node> globalActionNodes) {
            NodeTuple resourceTuple;
            TemplateReferences templateReferences = new TemplateReferences(globalActionNodes);
            for (int i = 0; i < resourceNode.getValue().size() && (resourceTuple = (NodeTuple)resourceNode.getValue().get(i)).getKeyNode().getNodeId() == NodeId.scalar; ++i) {
                String key = ((ScalarNode)resourceTuple.getKeyNode()).getValue();
                if (key.equals(TemplateResolver.RESOURCE_TYPE_USE_KEY)) {
                    templateReferences.typeReference = this.cloneNode(resourceTuple.getValueNode(), new HashMap<String, String>());
                    this.removeParametersFromTemplateCall(resourceTuple);
                    continue;
                }
                if (key.equals(TemplateResolver.TRAIT_USE_KEY) && this.expect(resourceTuple.getValueNode(), NodeId.sequence)) {
                    SequenceNode sequence = this.cloneSequenceNode((SequenceNode)resourceTuple.getValueNode(), new HashMap<String, String>());
                    templateReferences.traitsReference.put(TemplateResolver.ALL_ACTIONS, sequence);
                    this.removeParametersFromTraitsCall(resourceTuple);
                    continue;
                }
                if (!TemplateResolver.isAction(key)) continue;
                Node actionNode = resourceTuple.getValueNode();
                if (actionNode.getTag().equals((Object)Tag.NULL)) {
                    actionNode = this.setTupleValueToEmptyMappingNode(resourceTuple);
                } else if (actionNode.getTag().equals((Object)IncludeResolver.INCLUDE_TAG)) {
                    actionNode = TemplateResolver.this.includeResolver.resolve(actionNode, TemplateResolver.this.resourceLoader, TemplateResolver.this.nodeNandler);
                    resourceNode.getValue().remove(i);
                    resourceNode.getValue().add(i, new NodeTuple(resourceTuple.getKeyNode(), actionNode));
                }
                if (actionNode.getNodeId() != NodeId.mapping) break;
                templateReferences.actionNodes.put(TemplateResolver.normalizeKey(key), actionNode);
                for (NodeTuple actionTuple : ((MappingNode)actionNode).getValue()) {
                    String actionTupleKey = ((ScalarNode)actionTuple.getKeyNode()).getValue();
                    if (!actionTupleKey.equals(TemplateResolver.TRAIT_USE_KEY) || !this.expect(actionTuple.getValueNode(), NodeId.sequence)) continue;
                    SequenceNode sequence = this.cloneSequenceNode((SequenceNode)actionTuple.getValueNode(), new HashMap<String, String>());
                    templateReferences.traitsReference.put(TemplateResolver.normalizeKey(key), sequence);
                    this.removeParametersFromTraitsCall(actionTuple);
                }
            }
            return templateReferences;
        }

        private boolean expect(Node node, NodeId nodeId) {
            if (node.getNodeId() != nodeId) {
                this.addError(nodeId + " node expected", node);
                return false;
            }
            return true;
        }

        private void removeParametersFromTraitsCall(NodeTuple traitsNodeTuple) {
            if (traitsNodeTuple.getValueNode().getNodeId() == NodeId.sequence) {
                List traitList = ((SequenceNode)traitsNodeTuple.getValueNode()).getValue();
                for (int i = 0; i < traitList.size(); ++i) {
                    Node keyNode;
                    Node traitNode = (Node)traitList.get(i);
                    if (traitNode.getNodeId() != NodeId.mapping || (keyNode = ((NodeTuple)((MappingNode)traitNode).getValue().get(0)).getKeyNode()).getNodeId() != NodeId.scalar) continue;
                    traitList.remove(i);
                    traitList.add(i, keyNode);
                }
            }
        }

        private void removeParametersFromTemplateCall(NodeTuple typeNodeTuple) {
            if (typeNodeTuple.getValueNode().getNodeId() == NodeId.mapping) {
                NodeTuple typeParamTuple = (NodeTuple)((MappingNode)typeNodeTuple.getValueNode()).getValue().get(0);
                try {
                    Field value = typeNodeTuple.getClass().getDeclaredField("valueNode");
                    value.setAccessible(true);
                    value.set(typeNodeTuple, typeParamTuple.getKeyNode());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private Node setTupleValueToEmptyMappingNode(NodeTuple tuple) {
            try {
                Field value = tuple.getClass().getDeclaredField("valueNode");
                value.setAccessible(true);
                Node valueNode = tuple.getValueNode();
                MappingNode mappingNode = new MappingNode(Tag.MAP, false, new ArrayList(), valueNode.getStartMark(), valueNode.getEndMark(), DumperOptions.FlowStyle.BLOCK);
                value.set(tuple, mappingNode);
                return mappingNode;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void applyTraitsToActions(SequenceNode traits, Map<String, Node> actionNodes, String actionName) {
            for (Node ref : traits.getValue()) {
                if (actionName == null) {
                    for (Map.Entry<String, Node> actionEntry : actionNodes.entrySet()) {
                        this.currentAction = actionEntry.getKey();
                        MappingNode templateNode = this.cloneTemplate(ref, TemplateType.TRAIT);
                        if (templateNode == null) continue;
                        this.mergeNodes(actionEntry.getValue(), (Node)templateNode, new MergeContext(Action.class, templateNode.getTag()));
                    }
                    continue;
                }
                this.currentAction = actionName;
                MappingNode templateNode = this.cloneTemplate(ref, TemplateType.TRAIT);
                if (templateNode == null) continue;
                this.mergeNodes(actionNodes.get(actionName), (Node)templateNode, new MergeContext(Action.class, templateNode.getTag()));
            }
        }

        private MappingNode cloneTemplate(Node reference, TemplateType type) {
            String label;
            Map<String, MappingNode> templateMap;
            String templateName = this.getTemplateName(reference);
            if (templateName.isEmpty()) {
                return null;
            }
            HashMap<String, String> defaultParameters = new HashMap<String, String>();
            defaultParameters.put("resourcePath", this.relativeUri);
            defaultParameters.put("resourcePathName", this.getResourcePathName(this.fullUri));
            if (type == TemplateType.RESOURCE_TYPE) {
                templateMap = TemplateResolver.this.getResourceTypesMap();
                label = "resource type";
            } else {
                templateMap = TemplateResolver.this.getTraitsMap();
                label = "trait";
                defaultParameters.put("methodName", this.currentAction);
            }
            MappingNode templateNode = templateMap.get(templateName);
            if (templateNode == null) {
                this.addError(label + " not defined: " + templateName, reference);
                return null;
            }
            return this.cloneMappingNode(templateNode, this.getTemplateParameters(reference, defaultParameters));
        }

        private String getResourcePathName(String fullUri) {
            String[] paths = fullUri.split("/");
            for (int i = paths.length - 1; i >= 0; --i) {
                if (paths[i].contains("{") || paths[i].length() <= 0) continue;
                return paths[i];
            }
            return "";
        }

        private void addError(String message, Node node) {
            this.templateValidations.add(ValidationResult.createErrorResult(message, node));
        }

        private Map<String, String> getTemplateParameters(Node node, Map<String, String> parameters) {
            if (node.getNodeId() == NodeId.mapping) {
                List tuples = ((MappingNode)node).getValue();
                Node params = ((NodeTuple)tuples.get(0)).getValueNode();
                if (params.getTag() == Tag.NULL) {
                    return parameters;
                }
                if (params.getNodeId() != NodeId.mapping) {
                    this.addError("Mapping node expected", params);
                    return parameters;
                }
                for (NodeTuple paramTuple : ((MappingNode)params).getValue()) {
                    if (paramTuple.getKeyNode().getNodeId() != NodeId.scalar) {
                        this.addError("Scalar node expected", paramTuple.getKeyNode());
                        break;
                    }
                    if (paramTuple.getValueNode().getNodeId() != NodeId.scalar) {
                        this.addError("Scalar node expected", paramTuple.getValueNode());
                        break;
                    }
                    String paramKey = ((ScalarNode)paramTuple.getKeyNode()).getValue();
                    ScalarNode valueNode = (ScalarNode)paramTuple.getValueNode();
                    parameters.put(paramKey, this.resolveParameterValueInclude(valueNode));
                }
            }
            return parameters;
        }

        private String resolveParameterValueInclude(ScalarNode valueNode) {
            if (valueNode.getTag().equals((Object)IncludeResolver.INCLUDE_TAG)) {
                Node resolved = TemplateResolver.this.includeResolver.resolve((Node)valueNode, TemplateResolver.this.resourceLoader, TemplateResolver.this.nodeNandler);
                if (resolved.getNodeId() != NodeId.scalar) {
                    this.addError("Resource type and traits parameters must be scalars", (Node)valueNode);
                    return "";
                }
                valueNode = (ScalarNode)resolved;
            }
            return valueNode.getValue();
        }

        private String getTemplateName(Node templateReferenceNode) {
            Node templateNameNode = templateReferenceNode;
            if (templateReferenceNode.getNodeId() == NodeId.mapping) {
                templateNameNode = ((NodeTuple)((MappingNode)templateReferenceNode).getValue().get(0)).getKeyNode();
            }
            return ((ScalarNode)templateNameNode).getValue();
        }

        private void removeOptionalNodes(MappingNode node, boolean isResourceNode) {
            for (NodeTuple tuple : new ArrayList(node.getValue())) {
                String keyValue = ((ScalarNode)tuple.getKeyNode()).getValue();
                if (isResourceNode && keyValue.startsWith("/")) continue;
                if (this.isOptional(keyValue)) {
                    node.getValue().remove(tuple);
                    continue;
                }
                if (tuple.getValueNode().getNodeId() != NodeId.mapping) continue;
                this.removeOptionalNodes((MappingNode)tuple.getValueNode(), false);
            }
        }

        private MappingNode cloneMappingNode(MappingNode node, Map<String, String> parameters) {
            ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
            for (NodeTuple tuple : node.getValue()) {
                if (tuple.getKeyNode().getNodeId() != NodeId.scalar) {
                    this.addError("Only scalar keys are allowed", tuple.getKeyNode());
                    break;
                }
                ScalarNode key = this.cloneScalarNode((ScalarNode)tuple.getKeyNode(), parameters);
                Node value = this.cloneNode(tuple.getValueNode(), parameters);
                tuples.add(new NodeTuple((Node)key, value));
            }
            return new MappingNode(node.getTag(), tuples, node.getFlowStyle());
        }

        private Node cloneNode(Node valueNode, Map<String, String> parameters) {
            if (valueNode.getNodeId() == NodeId.mapping) {
                return this.cloneMappingNode((MappingNode)valueNode, parameters);
            }
            if (valueNode.getNodeId() == NodeId.sequence) {
                return this.cloneSequenceNode((SequenceNode)valueNode, parameters);
            }
            if (valueNode.getNodeId() == NodeId.scalar) {
                return this.cloneScalarNode((ScalarNode)valueNode, parameters);
            }
            this.addError("unsupported node type: " + valueNode.getNodeId(), valueNode);
            return null;
        }

        private SequenceNode cloneSequenceNode(SequenceNode node, Map<String, String> parameters) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node item : node.getValue()) {
                nodes.add(this.cloneNode(item, parameters));
            }
            return new SequenceNode(node.getTag(), nodes, node.getFlowStyle());
        }

        private ScalarNode cloneScalarNode(ScalarNode node, Map<String, String> parameters) {
            String value = node.getValue();
            Matcher matcher = TEMPLATE_PARAMETER_PATTERN.matcher(value);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                sb.append(this.resolveParameter(matcher.group(), parameters, node));
            }
            matcher.appendTail(sb);
            return new ScalarNode(node.getTag(), sb.toString(), node.getStartMark(), node.getEndMark(), node.getScalarStyle());
        }

        private String resolveParameter(String match, Map<String, String> parameters, ScalarNode node) {
            String[] tokens;
            String result = "";
            for (String token : tokens = match.substring(2, match.length() - 2).split("\\|")) {
                if (parameters.containsKey(token = token.trim())) {
                    result = parameters.get(token);
                    continue;
                }
                if (token.startsWith("!")) {
                    try {
                        Method method = Inflector.class.getMethod(token.substring(1), String.class);
                        result = (String)method.invoke(null, result);
                    }
                    catch (Exception e) {
                        this.addError("Invalid parameter function: " + token, (Node)node);
                    }
                    continue;
                }
                this.addError("Invalid parameter definition: " + match, (Node)node);
            }
            return result;
        }

        private MappingNode mergeMappingNodes(MappingNode baseNode, MappingNode templateNode, MergeContext context) {
            Map<String, NodeTuple> baseTupleMap = this.getTupleMap(baseNode);
            for (NodeTuple templateTuple : templateNode.getValue()) {
                String templateKey = ((ScalarNode)templateTuple.getKeyNode()).getValue();
                if (this.nonMergeableFields(context.keyNodeType).contains(templateKey)) continue;
                String baseKey = this.getMatchingKey(baseTupleMap, templateKey);
                if (baseKey == null) {
                    MergeContext nestedContext = context;
                    Node templateValueNode = TemplateResolver.this.resolveInclude(templateTuple.getValueNode(), context.templateInclude);
                    if (templateValueNode != templateTuple.getValueNode()) {
                        templateTuple = new NodeTuple(templateTuple.getKeyNode(), templateValueNode);
                        nestedContext = new MergeContext(Object.class, templateValueNode.getTag());
                    }
                    baseNode.getValue().add(nestedContext.tagInclude(templateTuple));
                    continue;
                }
                Node keyNode = baseTupleMap.get(baseKey).getKeyNode();
                if (this.isOptional(baseKey) && !this.isOptional(templateKey)) {
                    keyNode = templateTuple.getKeyNode();
                }
                Node baseInnerNode = baseTupleMap.get(baseKey).getValueNode();
                Node templateInnerNode = templateTuple.getValueNode();
                Node valueNode = this.mergeNodes(baseInnerNode, templateInnerNode, new MergeContext(context, baseKey));
                baseNode.getValue().remove(baseTupleMap.get(baseKey));
                baseNode.getValue().add(new NodeTuple(keyNode, valueNode));
            }
            return baseNode;
        }

        private Class<?> pushMergeContext(Class<?> context, String key) {
            if (context.equals(Resource.class) && TemplateResolver.isAction(key)) {
                return Action.class;
            }
            return Object.class;
        }

        private Node mergeNodes(Node baseNode, Node templateNode, MergeContext context) {
            if (baseNode.getNodeId() == NodeId.mapping && templateNode.getNodeId() == NodeId.mapping) {
                return this.mergeMappingNodes((MappingNode)baseNode, (MappingNode)templateNode, context);
            }
            if (templateNode.getNodeId() == NodeId.mapping) {
                return this.cleanMergedTuples((MappingNode)templateNode, context);
            }
            return baseNode;
        }

        private MappingNode cleanMergedTuples(MappingNode templateNode, MergeContext context) {
            ArrayList tuples = new ArrayList(templateNode.getValue());
            for (NodeTuple tuple : tuples) {
                String key = ((ScalarNode)tuple.getKeyNode()).getValue();
                if (this.nonMergeableFields(context.keyNodeType).contains(key)) {
                    templateNode.getValue().remove(tuple);
                    continue;
                }
                context.tagInclude(tuple);
            }
            return templateNode;
        }

        private Set nonMergeableFields(Class<?> element) {
            String[] fields = new String[]{};
            if (element.equals(Resource.class)) {
                fields = new String[]{"usage", "summary", "displayName", TemplateResolver.RESOURCE_TYPE_USE_KEY, TemplateResolver.TRAIT_USE_KEY};
            } else if (element.equals(Action.class)) {
                fields = new String[]{"usage", "summary", "displayName", TemplateResolver.TRAIT_USE_KEY};
            }
            return new HashSet<String>(Arrays.asList(fields));
        }

        private boolean isOptional(String key) {
            return key.endsWith(TemplateResolver.OPTIONAL_MODIFIER);
        }

        private String getMatchingKey(Map<String, NodeTuple> tupleMap, String key) {
            key = TemplateResolver.normalizeKey(key);
            for (String resourceKey : tupleMap.keySet()) {
                if (!TemplateResolver.normalizeKey(resourceKey).equals(key)) continue;
                return resourceKey;
            }
            return null;
        }

        private Map<String, NodeTuple> getTupleMap(MappingNode mappingNode) {
            HashMap<String, NodeTuple> tupleMap = new HashMap<String, NodeTuple>();
            for (NodeTuple tuple : mappingNode.getValue()) {
                tupleMap.put(((ScalarNode)tuple.getKeyNode()).getValue(), tuple);
            }
            return tupleMap;
        }
    }

    private static class MergeContext {
        Class<?> keyNodeType;
        Tag templateInclude;

        MergeContext(Class<?> keyNodeType, Tag templateInclude) {
            this.keyNodeType = keyNodeType;
            if (templateInclude != null && (templateInclude.startsWith("!include-applied_") || templateInclude.startsWith("!include-compound_"))) {
                this.templateInclude = templateInclude;
            }
        }

        MergeContext(MergeContext context, String baseKey) {
            this.templateInclude = context.templateInclude;
            if (context.keyNodeType.equals(Resource.class) && TemplateResolver.isAction(baseKey)) {
                this.keyNodeType = Action.class;
            }
            this.keyNodeType = Object.class;
        }

        NodeTuple tagInclude(NodeTuple tuple) {
            if (Tag.NULL.equals((Object)tuple.getValueNode().getTag())) {
                return tuple;
            }
            if (this.templateInclude != null) {
                tuple.getValueNode().setTag(this.templateInclude);
            }
            return tuple;
        }
    }

    private static class TemplateReferences {
        private Node typeReference = null;
        private Map<String, SequenceNode> traitsReference = new HashMap<String, SequenceNode>();
        private Map<String, Node> actionNodes;

        public TemplateReferences(Map<String, Node> globalActionNodes) {
            this.actionNodes = new HashMap<String, Node>(globalActionNodes);
        }
    }

    private static enum TemplateType {
        RESOURCE_TYPE,
        TRAIT;

    }
}

