/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.builder.SequenceBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.resolver.DefaultTupleHandler;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.utils.StreamUtils;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

public class YamlDocumentBuilder<T>
implements NodeHandler,
ContextPathAware {
    private Class<T> documentClass;
    private T documentObject;
    private Stack<NodeBuilder<?>> builderContext = new Stack();
    private Stack<Object> documentContext = new Stack();
    private MappingNode rootNode;
    private ResourceLoader resourceLoader;
    private TagResolver[] tagResolvers;
    private ContextPath contextPath;

    public YamlDocumentBuilder(Class<T> documentClass, ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        this.documentClass = documentClass;
        this.resourceLoader = resourceLoader;
        this.tagResolvers = tagResolvers;
    }

    public T build(String resourceLocation) {
        InputStream resourceStream = this.resourceLoader.fetchResource(resourceLocation);
        return this.build(resourceStream, resourceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T build(Reader content, String resourceLocation) {
        try {
            Yaml yamlParser = new Yaml();
            NodeVisitor nodeVisitor = new NodeVisitor(this, this.resourceLoader, this.tagResolvers);
            this.rootNode = (MappingNode)yamlParser.compose(content);
            this.contextPath.pushRoot(resourceLocation);
            this.preBuildProcess();
            nodeVisitor.visitDocument(this.rootNode);
            this.postBuildProcess();
            T t = this.documentObject;
            return t;
        }
        finally {
            IOUtils.closeQuietly((Reader)content);
        }
    }

    public T build(InputStream content, String resourceLocation) {
        return this.build(StreamUtils.reader(content), resourceLocation);
    }

    public T build(String content, String resourceLocation) {
        return this.build(new StringReader(content), resourceLocation);
    }

    @Deprecated
    public T build(Reader content) {
        return this.build(content, new File("").getPath());
    }

    @Deprecated
    public T build(InputStream content) {
        return this.build(StreamUtils.reader(content));
    }

    protected T getDocumentObject() {
        return this.documentObject;
    }

    protected Stack<NodeBuilder<?>> getBuilderContext() {
        return this.builderContext;
    }

    protected Stack<Object> getDocumentContext() {
        return this.documentContext;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    protected void preBuildProcess() {
    }

    protected void postBuildProcess() {
    }

    public MappingNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public boolean onMappingNodeStart(MappingNode mappingNode, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            throw new YAMLException("Only scalar keys are allowed: " + mappingNode.getStartMark());
        }
        NodeBuilder<?> currentBuilder = this.builderContext.peek();
        Object parentObject = this.documentContext.peek();
        Object object = ((TupleBuilder)currentBuilder).buildValue(parentObject, mappingNode);
        this.documentContext.push(object);
        return true;
    }

    @Override
    public void onMappingNodeEnd(MappingNode mappingNode, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            throw new YAMLException("Only scalar keys are allowed: " + mappingNode.getStartMark());
        }
        this.documentContext.pop();
    }

    @Override
    public boolean onSequenceStart(SequenceNode node, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            throw new YAMLException("Only scalar keys are allowed: " + node.getStartMark());
        }
        SequenceBuilder currentBuilder = (SequenceBuilder)((Object)this.builderContext.peek());
        Object parentObject = this.documentContext.peek();
        Object object = ((NodeBuilder)((Object)currentBuilder)).buildValue(parentObject, node);
        this.builderContext.push(currentBuilder.getItemBuilder());
        this.documentContext.push(object);
        return true;
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
        if (tupleType == TupleType.KEY) {
            throw new YAMLException("Only scalar keys are allowed: " + node.getStartMark());
        }
        this.documentContext.pop();
        this.builderContext.pop();
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        NodeBuilder<?> currentBuilder = this.builderContext.peek();
        Object parentObject = this.documentContext.peek();
        if (tupleType == TupleType.VALUE) {
            currentBuilder.buildValue(parentObject, node);
        } else {
            ((TupleBuilder)currentBuilder).buildKey(parentObject, node);
        }
    }

    @Override
    public boolean onDocumentStart(MappingNode node) {
        try {
            this.documentObject = this.documentClass.newInstance();
            this.documentContext.push(this.documentObject);
            this.builderContext.push(this.buildDocumentBuilder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private TupleBuilder<?, ?> buildDocumentBuilder() {
        DefaultTupleBuilder documentBuilder = new DefaultTupleBuilder(new DefaultTupleHandler());
        documentBuilder.addBuildersFor(this.documentClass);
        return documentBuilder;
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        if (this.documentObject != this.documentContext.pop()) {
            throw new IllegalStateException("more zombies?!");
        }
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        this.builderContext.pop();
    }

    @Override
    public boolean onTupleStart(NodeTuple nodeTuple) {
        TupleBuilder currentBuilder = (TupleBuilder)this.builderContext.peek();
        if (currentBuilder == null) {
            throw new IllegalStateException("Unexpected builderContext state");
        }
        NodeBuilder builder = currentBuilder.getBuilderForTuple(nodeTuple);
        this.builderContext.push(builder);
        return true;
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
    }

    @Override
    public void onCustomTagStart(Tag tag, Node originalValueNode, Node node) {
    }

    @Override
    public void onCustomTagEnd(Tag tag, Node originalValueNode, Node node) {
    }

    @Override
    public void onCustomTagError(Tag tag, Node node, String message) {
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag)) {
            throw new RuntimeException("resource not found: " + ((ScalarNode)node).getValue());
        }
    }

    public static String dumpFromAst(Node rootNode) {
        StringWriter writer = new StringWriter();
        YamlDocumentBuilder.dumpFromAst(rootNode, writer);
        return ((Object)writer).toString();
    }

    public static void dumpFromAst(Node rootNode, Writer output) {
        if (rootNode == null) {
            throw new IllegalArgumentException("rootNode is null");
        }
        DumperOptions dumperOptions = new DumperOptions();
        Tag rootTag = dumperOptions.getExplicitRoot();
        Serializer serializer = new Serializer((Emitable)new Emitter(output, dumperOptions), new Resolver(), dumperOptions, rootTag);
        try {
            serializer.open();
            serializer.serialize(rootNode);
            serializer.close();
        }
        catch (IOException e) {
            throw new YAMLException((Throwable)e);
        }
    }

    @Override
    public void setContextPath(ContextPath contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public ContextPath getContextPath() {
        return this.contextPath;
    }
}

