/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.UnknownTupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;

public class DefaultTupleRule<K extends Node, V extends Node>
implements TupleRule<K, Node> {
    protected Map<String, TupleRule<?, ?>> rules = new HashMap();
    private TupleRule<?, ?> parent;
    private TupleHandler tupleHandler;
    private boolean required;
    private K key;
    private String name;
    private NodeRuleFactory nodeRuleFactory;

    public DefaultTupleRule() {
    }

    public DefaultTupleRule(String name, TupleHandler handler, NodeRuleFactory nodeRuleFactory) {
        this(name, handler);
        this.setNodeRuleFactory(nodeRuleFactory);
    }

    public DefaultTupleRule(String name, TupleHandler handler) {
        this.name = name;
        this.tupleHandler = handler;
    }

    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void setNodeRuleFactory(NodeRuleFactory nodeRuleFactory) {
        this.nodeRuleFactory = nodeRuleFactory;
    }

    @Override
    public void setNestedRules(Map<String, TupleRule<?, ?>> rules) {
        this.rules = rules;
    }

    @Override
    public void setHandler(TupleHandler tupleHandler) {
        this.tupleHandler = tupleHandler;
    }

    @Override
    public TupleHandler getHandler() {
        return this.tupleHandler;
    }

    @Override
    public List<ValidationResult> validateKey(K key) {
        this.key = key;
        return new ArrayList<ValidationResult>();
    }

    @Override
    public final List<ValidationResult> validateValue(Node value) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (!Tag.NULL.equals((Object)value.getTag()) && !this.isValidValueNodeType(value.getClass())) {
            validationResults.add(ValidationResult.createErrorResult("Invalid value type", value));
        } else {
            validationResults.addAll(this.doValidateValue(value));
        }
        return validationResults;
    }

    public List<ValidationResult> doValidateValue(V value) {
        return new ArrayList<ValidationResult>();
    }

    protected boolean isValidValueNodeType(Class valueNodeClass) {
        for (Class<?> clazz : this.getValueNodeType()) {
            if (!clazz.isAssignableFrom(valueNodeClass)) continue;
            return true;
        }
        return false;
    }

    public Class<?>[] getValueNodeType() {
        return new Class[]{Node.class};
    }

    @Override
    public List<ValidationResult> onRuleEnd() {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        if (this.isRequired() && !this.wasAlreadyDefined()) {
            result.add(ValidationResult.createErrorResult(ValidationMessage.getMissingRuleMessage(this.name)));
        }
        for (TupleRule<?, ?> rule : this.rules.values()) {
            List<ValidationResult> onRuleEnd = rule.onRuleEnd();
            result.addAll(onRuleEnd);
        }
        return result;
    }

    private boolean wasAlreadyDefined() {
        return this.key != null;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValueType(Type valueType) {
    }

    @Override
    public TupleRule<?, ?> deepCopy() {
        this.checkClassToCopy(DefaultTupleRule.class);
        DefaultTupleRule<K, V> copy = new DefaultTupleRule<K, V>(this.name, this.tupleHandler, this.nodeRuleFactory);
        copy.setRequired(this.required);
        return copy;
    }

    protected void checkClassToCopy(Class<?> clazz) {
        if (!this.getClass().equals(clazz)) {
            throw new RuntimeException(this.getClass() + " must implement deepCopy");
        }
    }

    public void addRulesFor(Class<?> pojoClass) {
        this.nodeRuleFactory.addRulesTo(pojoClass, this);
    }

    public NodeRuleFactory getNodeRuleFactory() {
        return this.nodeRuleFactory;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        for (TupleRule<?, ?> rule : this.rules.values()) {
            if (!rule.getHandler().handles(nodeTuple)) continue;
            return rule;
        }
        return new UnknownTupleRule(nodeTuple.getKeyNode().toString());
    }

    @Override
    public void setParentTupleRule(TupleRule<?, ?> parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TupleRule<?, ?> getRuleByFieldName(String fieldName) {
        return this.rules.get(fieldName);
    }

    @Override
    public TupleRule<?, ?> getParentTupleRule() {
        return this.parent;
    }

    @Override
    public TupleRule<?, ?> getRootTupleRule() {
        TupleRule<?, ?> parentTupleRule = this.getParentTupleRule();
        if (parentTupleRule == null) {
            return null;
        }
        while (parentTupleRule.getParentTupleRule() != null) {
            parentTupleRule = parentTupleRule.getParentTupleRule();
        }
        return parentTupleRule;
    }
}

