/*
 * Decompiled with CFR 0.152.
 */
package org.raml;

import java.io.FileNotFoundException;
import java.util.List;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.RamlValidationService;

public class Validator {
    public static void main(String[] args) throws FileNotFoundException {
        if (args.length == 0) {
            System.out.println("\n\tusage: java -jar raml-parser-{version}.jar raml-resource ...\n");
            return;
        }
        new Validator().validate(args);
    }

    private void validate(String[] resources) throws FileNotFoundException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        for (String ramlResource : resources) {
            System.out.format("Validation Results for %s:\n", ramlResource);
            List<ValidationResult> results = RamlValidationService.createDefault().validate(loader.fetchResource(ramlResource), "");
            if (results.isEmpty()) {
                System.out.println("\tOK.");
            } else {
                for (ValidationResult item : results) {
                    this.printResult(item);
                }
            }
            System.out.println();
        }
    }

    private void printResult(ValidationResult item) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        stringBuilder.append((Object)item.getLevel());
        stringBuilder.append(" ");
        stringBuilder.append(item.getMessage());
        if (item.getLine() != -1) {
            stringBuilder.append(" (line ");
            stringBuilder.append(item.getLine());
            if (item.getStartColumn() != -1) {
                stringBuilder.append(", col ");
                stringBuilder.append(item.getStartColumn());
                if (item.getEndColumn() != item.getStartColumn()) {
                    stringBuilder.append(" to ");
                    stringBuilder.append(item.getEndColumn());
                }
            }
            stringBuilder.append(")");
        }
        System.out.println(stringBuilder.toString());
    }
}

