/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.AbstractReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.ContextAwareNode;
import org.raml.v2.internal.impl.commons.nodes.ContextAwareStringNodeImpl;
import org.raml.v2.internal.impl.commons.nodes.ResourceTypeNode;
import org.raml.v2.internal.impl.commons.nodes.SecuritySchemeNode;
import org.raml.v2.internal.impl.commons.nodes.TraitNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.v10.nodes.LibraryNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryRefNode;
import org.raml.yagi.framework.grammar.rule.ClassNodeFactory;
import org.raml.yagi.framework.grammar.rule.NodeFactory;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.NamedNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.util.NodeSelector;

public class NodeReferenceFactory
implements NodeFactory {
    private static final Map<String, Class<? extends NamedNode>> DECLARATION_SECTIONS = new HashMap<String, Class<? extends NamedNode>>();
    private static final String TYPES = "types";
    private static final String SCHEMAS = "schemas";
    private static final String RESOURCE_TYPES = "resourceTypes";
    private static final String TRAITS = "traits";
    private static final String SECURITY_SCHEMES = "securitySchemes";
    private static final String ANNOTATION_TYPES = "annotationTypes";
    private NodeFactory defaultFactory;

    public NodeReferenceFactory(Class<? extends Node> referenceClassNode) {
        this.defaultFactory = new ClassNodeFactory(referenceClassNode);
    }

    public Node create(@Nonnull Node currentNode, Object ... args) {
        String value = (String)args[0];
        return this.parse(currentNode, value, 0);
    }

    public Node parse(Node currentNode, String value, int startLocation) {
        String[] parts = this.getParts(currentNode, value);
        if (parts.length > 2) {
            return RamlErrorNodeFactory.createInvalidLibraryChaining(value);
        }
        Node result = null;
        Object parent = null;
        int currentShift = value.length();
        for (int i = parts.length - 1; i >= 0; --i) {
            String part = parts[i];
            Position endPosition = currentNode.getStartPosition().rightShift(startLocation + (currentShift -= part.length()) + value.length());
            Position startPosition = currentNode.getStartPosition().rightShift(startLocation + currentShift);
            if (parent == null) {
                parent = this.defaultFactory.create(currentNode, new Object[]{part});
                if (parent instanceof AbstractRamlNode) {
                    ((AbstractRamlNode)parent).setStartPosition(startPosition);
                    ((AbstractRamlNode)parent).setEndPosition(endPosition);
                }
                result = parent;
            } else {
                LibraryRefNode libraryRefNode = new LibraryRefNode(part);
                libraryRefNode.setStartPosition(startPosition);
                libraryRefNode.setEndPosition(endPosition);
                parent.addChild((Node)libraryRefNode);
                parent = libraryRefNode;
                --currentShift;
            }
            if (i != 0 || !(currentNode instanceof ContextAwareStringNodeImpl) || !(parent instanceof AbstractReferenceNode)) continue;
            ((AbstractReferenceNode)((Object)parent)).setContextNode(((ContextAwareNode)currentNode).getReferenceContext());
        }
        return result;
    }

    private String[] getParts(Node currentNode, String value) {
        if (!value.contains(".") || this.existsAsDeclaration(currentNode, value)) {
            return new String[]{value};
        }
        String[] allParts = value.split("\\.");
        Node libraryDeclarationsNode = NodeSelector.selectFrom((String)"uses", (Node)currentNode.getRootNode());
        if (libraryDeclarationsNode != null) {
            List libraryDeclarations = libraryDeclarationsNode.findDescendantsWith(LibraryNode.class);
            String libraryName = "";
            for (int i = 0; i < allParts.length - 1; ++i) {
                libraryName = i == 0 ? allParts[i] : libraryName + "." + allParts[i];
                for (LibraryNode libraryDeclaration : libraryDeclarations) {
                    if (!libraryName.equalsIgnoreCase(libraryDeclaration.getName())) continue;
                    int length = allParts.length - i;
                    String[] libraryReferenceParts = new String[length];
                    libraryReferenceParts[0] = libraryName;
                    System.arraycopy(allParts, i + 1, libraryReferenceParts, 1, length - 1);
                    return libraryReferenceParts;
                }
            }
        }
        return allParts;
    }

    private boolean existsAsDeclaration(Node currentNode, String value) {
        for (Map.Entry<String, Class<? extends NamedNode>> declarationSection : DECLARATION_SECTIONS.entrySet()) {
            Node node = NodeSelector.selectFrom((String)declarationSection.getKey(), (Node)currentNode.getRootNode());
            if (node == null) continue;
            List descendants = node.findDescendantsWith(declarationSection.getValue());
            for (NamedNode descendant : descendants) {
                if (!descendant.getName().equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        DECLARATION_SECTIONS.put(TYPES, TypeDeclarationField.class);
        DECLARATION_SECTIONS.put(SCHEMAS, TypeDeclarationField.class);
        DECLARATION_SECTIONS.put(RESOURCE_TYPES, ResourceTypeNode.class);
        DECLARATION_SECTIONS.put(TRAITS, TraitNode.class);
        DECLARATION_SECTIONS.put(SECURITY_SCHEMES, SecuritySchemeNode.class);
        DECLARATION_SECTIONS.put(ANNOTATION_TYPES, AnnotationTypeNode.class);
    }
}

