/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.ordermatch;

public class Order {
    private final long entryTime;
    private final String clientOrderId;
    private final String symbol;
    private final String owner;
    private final String target;
    private final char side;
    private final char type;
    private final double price;
    private final long quantity;
    private long openQuantity;
    private long executedQuantity;
    private double avgExecutedPrice;
    private double lastExecutedPrice;
    private long lastExecutedQuantity;

    public Order(String clientId, String symbol, String owner, String target, char side, char type, double price, long quantity) {
        this.clientOrderId = clientId;
        this.symbol = symbol;
        this.owner = owner;
        this.target = target;
        this.side = side;
        this.type = type;
        this.price = price;
        this.quantity = quantity;
        this.openQuantity = quantity;
        this.entryTime = System.currentTimeMillis();
    }

    public double getAvgExecutedPrice() {
        return this.avgExecutedPrice;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public long getExecutedQuantity() {
        return this.executedQuantity;
    }

    public long getLastExecutedQuantity() {
        return this.lastExecutedQuantity;
    }

    public long getOpenQuantity() {
        return this.openQuantity;
    }

    public String getOwner() {
        return this.owner;
    }

    public double getPrice() {
        return this.price;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public char getSide() {
        return this.side;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getTarget() {
        return this.target;
    }

    public char getType() {
        return this.type;
    }

    public boolean isFilled() {
        return this.quantity == this.executedQuantity;
    }

    public void cancel() {
        this.openQuantity = 0L;
    }

    public boolean isClosed() {
        return this.openQuantity == 0L;
    }

    public void execute(double price, long quantity) {
        this.avgExecutedPrice = ((double)quantity * price + this.avgExecutedPrice * (double)this.executedQuantity) / (double)(quantity + this.executedQuantity);
        this.openQuantity -= quantity;
        this.executedQuantity += quantity;
        this.lastExecutedPrice = price;
        this.lastExecutedQuantity = quantity;
    }

    public String toString() {
        return (this.side == '1' ? "BUY" : "SELL") + " " + this.quantity + "@$" + this.price + " (" + this.openQuantity + ")";
    }

    public long getEntryTime() {
        return this.entryTime;
    }

    public double getLastExecutedPrice() {
        return this.lastExecutedPrice;
    }
}

