/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.session;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.quickfixj.QFJException;
import org.quickfixj.jmx.mbean.session.SessionAdminMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionStateListener;
import quickfix.field.MsgType;
import quickfix.field.NewSeqNo;
import quickfix.field.converter.UtcTimestampConverter;

public class SessionAdmin
extends NotificationBroadcasterSupport
implements SessionAdminMBean,
MBeanRegistration,
SessionStateListener {
    private static final String NOTIFICATION_TYPE = "quickfix.Session";
    private final Session session;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectName connectorName;
    private MBeanServer mbeanServer;
    private final ObjectName settingsName;

    public SessionAdmin(Session session, ObjectName connectorName, ObjectName settingsName) {
        this.session = session;
        this.connectorName = connectorName;
        this.settingsName = settingsName;
    }

    public String getID() {
        return this.session.getSessionID().toString();
    }

    @Override
    public String getTargetCompID() {
        return this.session.getSessionID().getTargetCompID();
    }

    @Override
    public String getTargetSubID() {
        return this.session.getSessionID().getTargetSubID();
    }

    @Override
    public String getTargetLocationID() {
        return this.session.getSessionID().getTargetLocationID();
    }

    @Override
    public String getSenderCompID() {
        return this.session.getSessionID().getSenderCompID();
    }

    @Override
    public String getSenderSubID() {
        return this.session.getSessionID().getSenderSubID();
    }

    @Override
    public String getSenderLocationID() {
        return this.session.getSessionID().getSenderLocationID();
    }

    @Override
    public String getBeginString() {
        return this.session.getSessionID().getBeginString();
    }

    @Override
    public boolean isLoggedOn() {
        return this.session.isLoggedOn();
    }

    public String getRemoteIPAddress() {
        String remoteAddress = this.session.getRemoteAddress();
        if (remoteAddress != null) {
            return remoteAddress;
        }
        return "";
    }

    @Override
    public void reset() {
        this.logInvocation("reset");
        this.session.reset();
    }

    @Override
    public int getNextSenderMsgSeqNum() throws IOException {
        return this.session.getExpectedSenderNum();
    }

    @Override
    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.logAttributeChange("NextSenderMsgSeqNum", next);
        this.session.setNextSenderMsgSeqNum(next);
    }

    @Override
    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.logAttributeChange("NextTargetMsgSeqNum", next);
        this.session.setNextTargetMsgSeqNum(next);
    }

    @Override
    public int getNextTargetMsgSeqNum() throws IOException {
        return this.session.getExpectedTargetNum();
    }

    public String[] getMessages(int startSequence, int endSequence) throws IOException {
        ArrayList<String> messages = new ArrayList<String>();
        this.session.getStore().get(startSequence, endSequence, messages);
        return messages.toArray(new String[messages.size()]);
    }

    @Override
    public void disconnect() throws IOException {
        this.logInvocation("disconnect");
        this.session.disconnect("JMX admin", false);
    }

    @Override
    public void resetSequence(int nextSeqNum) throws SessionNotFound {
        this.logInvocation("resetSequence to: " + nextSeqNum);
        Message sequenceReset = new Message();
        sequenceReset.getHeader().setField(new MsgType("4"));
        sequenceReset.setField(new NewSeqNo(nextSeqNum));
        this.doSend(sequenceReset, this.session.getSessionID());
    }

    protected void doSend(Message message, SessionID sessionID) throws SessionNotFound {
        Session.sendToTarget(message, sessionID);
    }

    @Override
    public void logon() {
        this.logInvocation("logon");
        this.session.logon();
    }

    @Override
    public void logoff() {
        this.logInvocation("logout");
        this.session.logout();
    }

    public boolean isReconnectEnabled() {
        return this.session.isEnabled();
    }

    public String getHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            this.log.error(uhe.getMessage(), uhe);
            return "N/A";
        }
    }

    public String getProcessID() {
        return System.getProperty("java.pid");
    }

    @Override
    public ObjectName getConnectorName() {
        return this.connectorName;
    }

    @Override
    public boolean getCheckCompID() {
        return this.session.getCheckCompID();
    }

    @Override
    public String getLogClassName() {
        return this.session.getLog().getClass().getName();
    }

    @Override
    public int getLogonTimeout() {
        return this.session.getLogonTimeout();
    }

    @Override
    public int getLogoutTimeout() {
        return this.session.getLogoutTimeout();
    }

    @Override
    public String getMessageFactoryClassName() {
        return this.session.getMessageFactory().getClass().getName();
    }

    @Override
    public String getMessageStoreClassName() {
        return this.session.getStore().getClass().getName();
    }

    @Override
    public boolean getRedundantResendRequestsAllowed() {
        return this.session.getRedundantResentRequestsAllowed();
    }

    @Override
    public boolean getRefreshOnLogon() {
        return this.session.getRefreshOnLogon();
    }

    @Override
    public boolean getResetOnDisconnect() {
        return this.session.getResetOnDisconnect();
    }

    @Override
    public boolean getResetOnLogout() {
        return this.session.getResetOnLogout();
    }

    @Override
    public boolean isLogonAlreadySent() {
        return this.session.isLogonAlreadySent();
    }

    @Override
    public boolean isLogonReceived() {
        return this.session.isLogonReceived();
    }

    @Override
    public boolean isLogonSendNeeded() {
        return this.session.isLogonSendNeeded();
    }

    @Override
    public boolean isLogonSent() {
        return this.session.isLogonSent();
    }

    @Override
    public boolean isLogonTimedOut() {
        return this.session.isLogonTimedOut();
    }

    @Override
    public boolean isLogoutReceived() {
        return this.session.isLogoutReceived();
    }

    @Override
    public boolean isLogoutSent() {
        return this.session.isLogoutSent();
    }

    @Override
    public boolean isLogoutTimedOut() {
        return this.session.isLogoutTimedOut();
    }

    @Override
    public void setLogonTimeout(int seconds) {
        this.logAttributeChange("LogonTimeout", seconds);
        this.session.setLogonTimeout(seconds);
    }

    @Override
    public void setLogoutTimeout(int seconds) {
        this.logAttributeChange("LogoutTimeout", seconds);
        this.session.setLogoutTimeout(seconds);
    }

    @Override
    public boolean isUsingDataDictionary() {
        return this.session.isUsingDataDictionary();
    }

    @Override
    public String getSessionID() {
        return this.session.getSessionID().toString();
    }

    @Override
    public boolean getEnabled() {
        return this.session.isEnabled();
    }

    @Override
    public String getStartTime() {
        try {
            return UtcTimestampConverter.convert(this.session.getStartTime(), true);
        }
        catch (IOException e) {
            return "[ERROR]";
        }
    }

    @Override
    public String getConnectionRole() {
        try {
            return this.mbeanServer.getAttribute(this.connectorName, "Role").toString();
        }
        catch (Exception e) {
            return "[ERROR: " + e.getMessage() + "]";
        }
    }

    private void logAttributeChange(String attributeName, int value) {
        this.session.getLog().onEvent("JMX: setting " + attributeName + " to " + value);
    }

    private void logInvocation(String operation) {
        this.session.getLog().onEvent("JMX: " + operation + " invoked");
    }

    @Override
    public void postDeregister() {
        try {
            this.mbeanServer.unregisterMBean(this.settingsName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QFJException("Connector MBean postregistration failed", e);
        }
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        return name;
    }

    @Override
    public void onConnect() {
        this.sendNotification("connect");
    }

    @Override
    public void onDisconnect() {
        this.sendNotification("disconnect");
    }

    @Override
    public void onLogon() {
        this.sendNotification("logon");
    }

    @Override
    public void onLogout() {
        this.sendNotification("logout");
    }

    @Override
    public void onHeartBeatTimeout() {
        this.sendNotification("heartBeatTimeout");
    }

    @Override
    public void onMissedHeartBeat() {
        this.sendNotification("missedHeartBeat");
    }

    @Override
    public void onRefresh() {
        this.sendNotification("refresh");
    }

    @Override
    public void onResendRequestSent(int beginSeqNo, int endSeqNo, int currentEndSeqNo) {
        this.sendNotification("resendRequestSent");
    }

    @Override
    public void onSequenceResetReceived(int newSeqNo, boolean gapFillFlag) {
        this.sendNotification("sequenceResetReceived");
    }

    @Override
    public void onResendRequestSatisfied(int beginSeqNo, int endSeqNo) {
        this.sendNotification("resentRequestSatisfied");
    }

    @Override
    public void onReset() {
        this.sendNotification("reset");
    }

    private void sendNotification(String eventName) {
        Notification notification = new Notification(NOTIFICATION_TYPE, this, -1L, System.currentTimeMillis(), eventName);
        this.sendNotification(notification);
    }

    @Override
    public void sendTestRequest() {
        this.session.generateTestRequest(System.currentTimeMillis() + "");
    }

    @Override
    public void sendHeartBeat() {
        this.session.generateHeartbeat();
    }

    @Override
    public void sendLogoutMessage() {
        this.session.generateLogout();
    }
}

