/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import java.util.Arrays;

public class SSLConfig {
    private String keyStoreName;
    private char[] keyStorePassword;
    private String keyManagerFactoryAlgorithm;
    private String keyStoreType;
    private String trustStoreName;
    private char[] trustStorePassword;
    private String trustManagerFactoryAlgorithm;
    private String trustStoreType;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private boolean needClientAuth;
    private boolean useSNI;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSLConfig other = (SSLConfig)obj;
        if (!Arrays.equals(this.enabledCipherSuites, other.enabledCipherSuites)) {
            return false;
        }
        if (!Arrays.equals(this.enabledProtocols, other.enabledProtocols)) {
            return false;
        }
        if (this.keyManagerFactoryAlgorithm == null ? other.keyManagerFactoryAlgorithm != null : !this.keyManagerFactoryAlgorithm.equals(other.keyManagerFactoryAlgorithm)) {
            return false;
        }
        if (this.keyStoreName == null ? other.keyStoreName != null : !this.keyStoreName.equals(other.keyStoreName)) {
            return false;
        }
        if (!Arrays.equals(this.keyStorePassword, other.keyStorePassword)) {
            return false;
        }
        if (this.keyStoreType == null ? other.keyStoreType != null : !this.keyStoreType.equals(other.keyStoreType)) {
            return false;
        }
        if (this.needClientAuth != other.needClientAuth) {
            return false;
        }
        if (this.trustManagerFactoryAlgorithm == null ? other.trustManagerFactoryAlgorithm != null : !this.trustManagerFactoryAlgorithm.equals(other.trustManagerFactoryAlgorithm)) {
            return false;
        }
        if (this.trustStoreName == null ? other.trustStoreName != null : !this.trustStoreName.equals(other.trustStoreName)) {
            return false;
        }
        if (!Arrays.equals(this.trustStorePassword, other.trustStorePassword)) {
            return false;
        }
        if (this.useSNI != other.useSNI) {
            return false;
        }
        if (this.trustStoreType == null) {
            return other.trustStoreType == null;
        }
        return this.trustStoreType.equals(other.trustStoreType);
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public String getKeyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public String getKeyStoreName() {
        return this.keyStoreName;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }

    public String getTrustStoreName() {
        return this.trustStoreName;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.enabledCipherSuites);
        result = 31 * result + Arrays.hashCode(this.enabledProtocols);
        result = 31 * result + (this.keyManagerFactoryAlgorithm == null ? 0 : this.keyManagerFactoryAlgorithm.hashCode());
        result = 31 * result + (this.keyStoreName == null ? 0 : this.keyStoreName.hashCode());
        result = 31 * result + Arrays.hashCode(this.keyStorePassword);
        result = 31 * result + (this.keyStoreType == null ? 0 : this.keyStoreType.hashCode());
        result = 31 * result + (this.needClientAuth ? 1231 : 1237);
        result = 31 * result + (this.trustManagerFactoryAlgorithm == null ? 0 : this.trustManagerFactoryAlgorithm.hashCode());
        result = 31 * result + (this.trustStoreName == null ? 0 : this.trustStoreName.hashCode());
        result = 31 * result + Arrays.hashCode(this.trustStorePassword);
        result = 31 * result + (this.trustStoreType == null ? 0 : this.trustStoreType.hashCode());
        return result;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean isUseSNI() {
        return this.useSNI;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
    }

    public void setKeyStoreName(String keyStoreName) {
        this.keyStoreName = keyStoreName;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setUseSNI(boolean useSNI) {
        this.useSNI = useSNI;
    }

    public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
    }

    public void setTrustStoreName(String trustStoreName) {
        this.trustStoreName = trustStoreName;
    }

    public void setTrustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }
}

