/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Log;

class CompositeLog
implements Log {
    private final Logger defaultLog = LoggerFactory.getLogger(this.getClass());
    private final Log[] logs;
    private boolean rethrowException;

    public CompositeLog(Log[] logs) {
        this.logs = logs;
    }

    @Override
    public void clear() {
        for (Log log : this.logs) {
            try {
                log.clear();
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(Throwable e) {
        if (this.rethrowException) {
            throw new RuntimeException(e);
        }
        this.defaultLog.error(e.getMessage() + ", continuing", e);
    }

    @Override
    public void onIncoming(String message) {
        for (Log log : this.logs) {
            try {
                log.onIncoming(message);
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void onOutgoing(String message) {
        for (Log log : this.logs) {
            try {
                log.onOutgoing(message);
            }
            catch (Throwable e) {
                this.defaultLog.error(e.getMessage() + ", continuing", e);
            }
        }
    }

    @Override
    public void onEvent(String text) {
        for (Log log : this.logs) {
            try {
                log.onEvent(text);
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    @Override
    public void onErrorEvent(String text) {
        for (Log log : this.logs) {
            try {
                log.onErrorEvent(text);
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
    }

    void setRethrowExceptions(boolean flag) {
        this.rethrowException = flag;
    }
}

