/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.SyspathArchive;
import org.python.core.imp;

public class ZipFileImporter
extends PyObject {
    private SyspathArchive archive;
    private String pathToArchive;

    public ZipFileImporter(PyObject pyObject) {
        if (!(pyObject instanceof SyspathArchive)) {
            throw Py.ImportError(pyObject.toString());
        }
        this.archive = (SyspathArchive)pyObject;
        String string = SyspathArchive.getArchiveName(this.archive.string);
        this.pathToArchive = new File(string).getAbsolutePath() + File.separatorChar;
    }

    public PyObject find_module(String string) {
        return this.find_module(string, Py.None);
    }

    public PyObject find_module(String string, PyObject pyObject) {
        ZipModuleInfo zipModuleInfo = this.getModuleInfo(string, this.archive);
        return zipModuleInfo == null ? Py.None : new ZipFileLoader(zipModuleInfo);
    }

    public String toString() {
        return this.getType().toString();
    }

    private String getSubName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private ZipModuleInfo getModuleInfo(String string, SyspathArchive syspathArchive) {
        boolean bl;
        String string2 = this.getSubName(string);
        String string3 = string2 + "/__init__.py";
        String string4 = string2 + "/__init__$py.class";
        ZipEntry zipEntry = syspathArchive.getEntry(string3);
        ZipEntry zipEntry2 = syspathArchive.getEntry(string4);
        boolean bl2 = bl = zipEntry != null || zipEntry2 != null;
        if (!bl) {
            string3 = string2 + ".py";
            string4 = string2 + "$py.class";
            zipEntry = syspathArchive.getEntry(string3);
            zipEntry2 = syspathArchive.getEntry(string4);
        } else {
            syspathArchive = syspathArchive.makeSubfolder(string2);
        }
        ZipModuleInfo zipModuleInfo = null;
        if (zipEntry != null) {
            Py.writeDebug("import", "trying source entry: " + string3 + " from jar/zip file " + syspathArchive);
            if (zipEntry2 != null) {
                Py.writeDebug("import", "trying precompiled entry " + string4 + " from jar/zip file " + syspathArchive);
                long l = zipEntry.getTime();
                long l2 = zipEntry2.getTime();
                if (l2 >= l) {
                    zipModuleInfo = new ZipModuleInfo(syspathArchive, zipEntry2, true);
                }
            }
            if (zipModuleInfo == null) {
                zipModuleInfo = new ZipModuleInfo(syspathArchive, zipEntry, false);
            }
        }
        if (bl && zipModuleInfo != null) {
            zipModuleInfo.path = new PyList(new PyObject[]{syspathArchive});
        }
        return zipModuleInfo;
    }

    private class ZipModuleInfo {
        public PyObject path;
        public boolean compiled;
        public ZipEntry zipEntry;
        public SyspathArchive archive;

        public ZipModuleInfo(SyspathArchive syspathArchive, ZipEntry zipEntry, boolean bl) {
            this(syspathArchive, zipEntry, bl, null);
        }

        public ZipModuleInfo(SyspathArchive syspathArchive, ZipEntry zipEntry, boolean bl, PyObject pyObject) {
            this.path = pyObject;
            this.archive = syspathArchive;
            this.zipEntry = zipEntry;
            this.compiled = bl;
        }
    }

    public class ZipFileLoader
    extends PyObject {
        private ZipModuleInfo _info;

        public ZipFileLoader(ZipModuleInfo zipModuleInfo) {
            this._info = zipModuleInfo;
        }

        public PyObject load_module(String string) {
            PyModule pyModule = null;
            if (this._info.path != null) {
                pyModule = imp.addModule(string);
                pyModule.__dict__.__setitem__("__path__", this._info.path);
                pyModule.__dict__.__setitem__("__loader__", (PyObject)this);
            }
            InputStream inputStream = null;
            ZipEntry zipEntry = this._info.zipEntry;
            try {
                inputStream = this._info.archive.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                Py.writeDebug("import", "loadFromZipFile exception: " + iOException.toString());
                throw Py.ImportError("error loading from zipfile");
            }
            String string2 = ZipFileImporter.this.pathToArchive + zipEntry.getName();
            PyObject pyObject = this._info.compiled ? imp.createFromPyClass(string, inputStream, true, string2) : imp.createFromSource(string, inputStream, string2, null);
            return pyModule == null ? pyObject : pyModule;
        }

        public String toString() {
            return this.getType().toString();
        }
    }
}

