/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.util.BreakTraceFunction;
import org.python.util.PythonInterpreter;

public class InteractiveInterpreter
extends PythonInterpreter {
    public StringBuffer buffer = new StringBuffer();
    public String filename = "<stdin>";

    public InteractiveInterpreter() {
        this.cflags = new CompilerFlags();
    }

    public InteractiveInterpreter(PyObject pyObject) {
        super(pyObject);
        this.cflags = new CompilerFlags();
    }

    public boolean runsource(String string) {
        return this.runsource(string, "<input>", "single");
    }

    public boolean runsource(String string, String string2) {
        return this.runsource(string, string2, "single");
    }

    public boolean runsource(String string, String string2, String string3) {
        PyObject pyObject;
        try {
            pyObject = Py.compile_command_flags(string, string2, string3, this.cflags, true);
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.SyntaxError)) {
                this.showexception(pyException);
                return false;
            }
            if (Py.matchException(pyException, Py.ValueError) || Py.matchException(pyException, Py.OverflowError)) {
                this.showexception(pyException);
                return false;
            }
            throw pyException;
        }
        if (pyObject == Py.None) {
            return true;
        }
        this.runcode(pyObject);
        return false;
    }

    public void runcode(PyObject pyObject) {
        try {
            this.exec(pyObject);
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.SystemExit)) {
                throw pyException;
            }
            this.showexception(pyException);
        }
    }

    public void showexception(PyException pyException) {
        Py.printException(pyException);
    }

    public void write(String string) {
        Py.stderr.write(string);
    }

    public void resetbuffer() {
        this.buffer.setLength(0);
    }

    public void interrupt(ThreadState threadState) {
        BreakTraceFunction breakTraceFunction = new BreakTraceFunction();
        TraceFunction traceFunction = threadState.systemState.tracefunc;
        threadState.systemState.tracefunc = breakTraceFunction;
        if (threadState.frame != null) {
            threadState.frame.tracefunc = breakTraceFunction;
        }
        threadState.systemState.tracefunc = traceFunction;
    }
}

