/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class Chips
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public List<String> getValues() {
        List<WebElement> chipTokens = this.getChipTokens();
        return chipTokens.stream().map(token -> token.findElement(By.className((String)"ui-chips-token-label")).getText()).collect(Collectors.toList());
    }

    public List<WebElement> getChipTokens() {
        return this.findElements(By.cssSelector((String)"ul li.ui-chips-token"));
    }

    public void addValue(String value) {
        WebElement chipsInput = this.getInput();
        chipsInput.sendKeys(new CharSequence[]{value});
        if (ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemSelect")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)chipsInput)).sendKeys(new CharSequence[]{Keys.ENTER});
        } else {
            chipsInput.sendKeys(new CharSequence[]{Keys.ENTER});
        }
    }

    public void removeValue(String value) {
        for (WebElement chipToken : this.getChipTokens()) {
            if (!chipToken.findElement(By.className((String)"ui-chips-token-label")).getText().equals(value)) continue;
            WebElement closeIcon = chipToken.findElement(By.className((String)"ui-icon-close"));
            if (ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemUnselect")) {
                ((WebElement)PrimeSelenium.guardAjax((Object)closeIcon)).click();
                continue;
            }
            closeIcon.click();
        }
    }

    public void toggleEditor() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".toggleEditor();"), (Object[])new Object[0]);
    }
}

