/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.model.datatable;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.model.datatable.Cell;

public class Row {
    private WebElement webElement;
    private List<Cell> cells;

    public Row(WebElement webElement, List<Cell> cells) {
        this.webElement = webElement;
        this.cells = cells;
    }

    public boolean isToggleable() {
        return this.getToggler() != null;
    }

    public WebElement getToggler() {
        try {
            return this.webElement.findElement(By.className((String)"ui-row-toggler"));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void toggle() {
        if (this.isToggleable()) {
            ((WebElement)PrimeSelenium.guardAjax((Object)this.getToggler())).click();
        }
    }

    public boolean isExpanded() {
        return Boolean.parseBoolean(this.getToggler().getDomAttribute("aria-expanded"));
    }

    public void expand() {
        if (!this.isExpanded()) {
            this.toggle();
        }
    }

    public void collapse() {
        if (this.isExpanded()) {
            this.toggle();
        }
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public Cell getCell(int index) {
        return this.cells.get(index);
    }
}

