/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.base.ComponentUtils;

public abstract class AbstractInputComponent
extends AbstractComponent {
    public WebElement getInput() {
        return this.getRoot();
    }

    public boolean isEnabled() {
        return this.getInput().isEnabled() && !PrimeSelenium.hasCssClass((WebElement)this, (String[])new String[]{"ui-state-disabled"});
    }

    public boolean isOnchangeAjaxified() {
        return this.isAjaxified(this.getInput(), "onchange") || ComponentUtils.hasAjaxBehavior(this.getRoot(), "change");
    }

    public WebElement getAssignedLabel() {
        return this.getWebDriver().findElement(By.cssSelector((String)("label[for='" + this.getInput().getDomAttribute("id") + "']")));
    }

    public String getAssignedLabelText() {
        return this.getAssignedLabel().getText();
    }

    public String copyToClipboard() {
        WebElement input = this.getInput();
        Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "c"})});
        return input.getDomAttribute("value");
    }

    public String pasteFromClipboard() {
        WebElement input = this.getInput();
        Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
        input.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "v"})});
        return input.getDomAttribute("value");
    }

    public void selectAllText() {
        Keys command = PrimeSelenium.isMacOs() ? Keys.COMMAND : Keys.CONTROL;
        this.getInput().sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{command, "a"})});
    }

    public void clear() {
        PrimeSelenium.clearInput((WebElement)this.getInput(), (boolean)false);
    }

    public void enable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".enable();"), (Object[])new Object[0]);
    }

    public void disable() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".disable();"), (Object[])new Object[0]);
    }

    public void focus() {
        new Actions(this.getWebDriver()).moveToElement(this.getInput()).click().perform();
    }
}

