/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.model.tree;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.Tree;

public class TreeNode {
    private TreeNode parent;
    private Tree tree;
    private String rowKey;

    public TreeNode(Tree tree, String rowKey, TreeNode parent) {
        this.tree = tree;
        this.rowKey = rowKey;
        this.parent = parent;
    }

    public WebElement getWebElement() {
        return this.tree.findElement(By.cssSelector((String)(".ui-treenode[data-rowkey='" + this.rowKey + "']")));
    }

    public Tree getTree() {
        return this.tree;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public void toggle() {
        ((WebElement)PrimeSelenium.guardAjax((Object)this.getTreeToggler())).click();
    }

    public void select() {
        ((WebElement)PrimeSelenium.guardAjax((Object)this.getLabel())).click();
    }

    public WebElement getTreeToggler() {
        return this.getWebElement().findElement(By.cssSelector((String)".ui-treenode-content .ui-tree-toggler"));
    }

    public String getLabelText() {
        return this.getLabel().getText();
    }

    public WebElement getLabel() {
        return this.getWebElement().findElement(By.cssSelector((String)".ui-treenode-content .ui-treenode-label"));
    }

    public List<TreeNode> getChildren() {
        return this.getWebElement().findElements(By.xpath((String)"./ul/li[contains(@class, 'ui-treenode')]")).stream().map(e -> new TreeNode(this.tree, e.getDomAttribute("data-rowkey"), this)).collect(Collectors.toList());
    }

    public boolean isExpanded() {
        WebElement children = this.getWebElement().findElement(By.xpath((String)"./ul"));
        return PrimeSelenium.isElementDisplayed((WebElement)children);
    }

    public boolean isSelected() {
        return PrimeSelenium.hasCssClass((WebElement)this.getWebElement(), (String[])new String[]{"ui-treenode-selected"});
    }

    public boolean isPartialSelected() {
        return PrimeSelenium.hasCssClass((WebElement)this.getWebElement(), (String[])new String[]{"ui-treenode-hasselected"});
    }
}

