/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

public abstract class SelectManyMenu
extends AbstractInputComponent {
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindBy(css=".ui-selectlistbox-listcontainer .ui-selectlistbox-list")
    private WebElement selectlistbox;
    @FindByParentPartialId(value="_filter", searchFromRoot=true)
    private WebElement filterInput;

    public boolean isItemSelectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemSelect");
    }

    public boolean isItemUnselectAjaxified() {
        return ComponentUtils.hasAjaxBehavior(this.getRoot(), "itemUnselect");
    }

    public void deselect(String label) {
        this.deselect(label, this.isItemUnselectAjaxified());
    }

    public void deselect(String label, boolean withGuardAjax) {
        if (!this.isSelected(label)) {
            return;
        }
        this.toggleSelection(label, true, withGuardAjax);
    }

    public void select(String label, boolean withMetaKey) {
        this.select(label, withMetaKey, this.isItemSelectAjaxified());
    }

    public void select(String label, boolean withMetaKey, boolean withGuardAjax) {
        if (this.isSelected(label)) {
            return;
        }
        this.toggleSelection(label, withMetaKey, withGuardAjax);
    }

    public void toggleSelection(String label, boolean withMetaKey) {
        this.toggleSelection(label, withMetaKey, false);
    }

    public void toggleSelection(String label, boolean withMetaKey, boolean withGuardAjax) {
        if (!this.isEnabled()) {
            return;
        }
        this.clickOnListItemWithMetaKey(label, withMetaKey, withGuardAjax);
    }

    private void clickOnListItemWithMetaKey(String label, boolean withMetaKey, boolean withGuardAjax) {
        for (WebElement element : this.getSelectlistbox().findElements(By.tagName((String)"li"))) {
            if (!element.getText().equalsIgnoreCase(label)) continue;
            if (withMetaKey) {
                Actions actions = new Actions(this.getWebDriver());
                Action action = actions.keyDown((CharSequence)Keys.META).click(element).keyUp((CharSequence)Keys.META).build();
                if (withGuardAjax) {
                    action = (Action)PrimeSelenium.guardAjax((Object)action);
                }
                action.perform();
                break;
            }
            if (withGuardAjax) {
                element = (WebElement)PrimeSelenium.guardAjax((Object)element);
            }
            element.click();
            break;
        }
    }

    public boolean isSelected(String label) {
        try {
            for (WebElement element : this.getSelectlistbox().findElements(By.tagName((String)"li"))) {
                if (!element.getText().equalsIgnoreCase(label) || !PrimeSelenium.hasCssClass((WebElement)element, (String[])new String[]{"ui-state-highlight"})) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public List<String> getLabels() {
        JSONObject widgetConfiguration = this.getWidgetConfiguration();
        if (widgetConfiguration.has("filter") && widgetConfiguration.getBoolean("filter")) {
            return this.getSelectlistbox().findElements(By.cssSelector((String)"li.ui-selectlistbox-item")).stream().filter(listElt -> listElt.isDisplayed()).map(e -> e.getAttribute("innerHTML")).collect(Collectors.toList());
        }
        return this.getInput().findElements(By.tagName((String)"option")).stream().map(e -> e.getAttribute("innerHTML")).collect(Collectors.toList());
    }

    public boolean isSelected(int index) {
        return this.isSelected(this.getLabel(index));
    }

    public String getLabel(int index) {
        return this.getLabels().get(index);
    }

    public List<String> getSelectedLabels() {
        ArrayList<String> selectedLabels = new ArrayList<String>();
        for (WebElement element : this.getSelectlistbox().findElements(By.tagName((String)"li"))) {
            if (!PrimeSelenium.hasCssClass((WebElement)element, (String[])new String[]{"ui-state-highlight"})) continue;
            selectedLabels.add(element.getText());
        }
        return selectedLabels;
    }

    @Override
    public WebElement getInput() {
        return this.input;
    }

    public WebElement getSelectlistbox() {
        return this.selectlistbox;
    }

    public WebElement getFilterInput() {
        return this.filterInput;
    }
}

